/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v1.runtime.spi.BookmarkResult;
import org.neo4j.cypher.InvalidSemanticsException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachine
implements StatementProcessor {
    final TransactionStateMachineSPI spi;
    final MutableTransactionState ctx;
    State state = State.AUTO_COMMIT;

    TransactionStateMachine(TransactionStateMachineSPI spi, AuthenticationResult authenticationResult, Clock clock) {
        this.spi = spi;
        this.ctx = new MutableTransactionState(authenticationResult, clock);
    }

    public State state() {
        return this.state;
    }

    private void before() {
        if (this.ctx.currentTransaction != null) {
            this.spi.bindTransactionToCurrentThread(this.ctx.currentTransaction);
        }
    }

    @Override
    public void beginTransaction(Bookmark bookmark) throws KernelException {
        this.beginTransaction(bookmark, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Bookmark bookmark, Duration txTimeout, Map<String, Object> txMetadata) throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.beginTransaction(this.ctx, this.spi, bookmark, txTimeout, txMetadata);
        }
        finally {
            this.after();
        }
    }

    @Override
    public StatementMetadata run(String statement, MapValue params) throws KernelException {
        return this.run(statement, params, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementMetadata run(String statement, MapValue params, Bookmark bookmark, Duration txTimeout, Map<String, Object> txMetaData) throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.run(this.ctx, this.spi, statement, params, bookmark, txTimeout, txMetaData);
            StatementMetadata statementMetadata = this.ctx.currentStatementMetadata;
            return statementMetadata;
        }
        finally {
            this.after();
        }
    }

    @Override
    public Bookmark streamResult(ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            Bookmark bookmark = this.state.streamResult(this.ctx, this.spi, resultConsumer);
            return bookmark;
        }
        finally {
            this.after();
        }
    }

    @Override
    public Bookmark commitTransaction() throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.commitTransaction(this.ctx, this.spi);
            Bookmark bookmark = TransactionStateMachine.newestBookmark(this.spi);
            return bookmark;
        }
        catch (TransactionFailureException ex) {
            this.state = State.AUTO_COMMIT;
            throw ex;
        }
        finally {
            this.after();
        }
    }

    @Override
    public void rollbackTransaction() throws KernelException {
        this.before();
        try {
            this.ensureNoPendingTerminationNotice();
            this.state = this.state.rollbackTransaction(this.ctx, this.spi);
        }
        finally {
            this.after();
        }
    }

    @Override
    public boolean hasOpenStatement() {
        return this.ctx.currentResultHandle != null;
    }

    @Override
    public void reset() throws TransactionFailureException {
        this.state.terminateQueryAndRollbackTransaction(this.ctx);
        this.state = State.AUTO_COMMIT;
    }

    private void after() {
        this.spi.unbindTransactionFromCurrentThread();
    }

    @Override
    public void markCurrentTransactionForTermination() {
        KernelTransaction tx = this.ctx.currentTransaction;
        if (tx != null) {
            tx.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    @Override
    public void validateTransaction() throws KernelException {
        Optional statusOpt;
        KernelTransaction tx = this.ctx.currentTransaction;
        if (tx != null && (statusOpt = tx.getReasonIfTerminated()).isPresent() && ((Status)statusOpt.get()).code().classification().rollbackTransaction()) {
            this.ctx.pendingTerminationNotice = (Status)statusOpt.get();
            this.reset();
        }
    }

    private void ensureNoPendingTerminationNotice() {
        if (this.ctx.pendingTerminationNotice != null) {
            Status status = this.ctx.pendingTerminationNotice;
            this.ctx.pendingTerminationNotice = null;
            throw new TransactionTerminatedException(status);
        }
    }

    @Override
    public boolean hasTransaction() {
        return this.state == State.EXPLICIT_TRANSACTION;
    }

    private static void waitForBookmark(TransactionStateMachineSPI spi, Bookmark bookmark) throws TransactionFailureException {
        if (bookmark != null) {
            spi.awaitUpToDate(bookmark.txId());
        }
    }

    private static Bookmark newestBookmark(TransactionStateMachineSPI spi) {
        long txId = spi.newestEncounteredTxId();
        return new Bookmark(txId);
    }

    static class MutableTransactionState {
        final LoginContext loginContext;
        KernelTransaction currentTransaction;
        Status pendingTerminationNotice;
        String lastStatement = "";
        BoltResult currentResult;
        BoltResultHandle currentResultHandle;
        final Clock clock;
        private final StatementMetadata currentStatementMetadata = new StatementMetadata(){

            @Override
            public String[] fieldNames() {
                return currentResult.fieldNames();
            }
        };

        private MutableTransactionState(AuthenticationResult authenticationResult, Clock clock) {
            this.clock = clock;
            this.loginContext = authenticationResult.getLoginContext();
        }
    }

    static enum State {
        AUTO_COMMIT{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, Bookmark bookmark, Duration txTimeout, Map<String, Object> txMetadata) throws KernelException {
                TransactionStateMachine.waitForBookmark(spi, bookmark);
                ctx.currentResult = BoltResult.EMPTY;
                ctx.currentTransaction = spi.beginTransaction(ctx.loginContext, txTimeout, txMetadata);
                return EXPLICIT_TRANSACTION;
            }

            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, Bookmark bookmark, Duration txTimeout, Map<String, Object> txMetadata) throws KernelException {
                statement = this.parseStatement(ctx, statement);
                TransactionStateMachine.waitForBookmark(spi, bookmark);
                this.execute(ctx, spi, statement, params, spi.isPeriodicCommit(statement), txTimeout, txMetadata);
                return AUTO_COMMIT;
            }

            private String parseStatement(MutableTransactionState ctx, String statement) {
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                return statement;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void execute(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, boolean isPeriodicCommit, Duration txTimeout, Map<String, Object> txMetadata) throws KernelException {
                if (!isPeriodicCommit) {
                    ctx.currentTransaction = spi.beginTransaction(ctx.loginContext, txTimeout, txMetadata);
                }
                boolean failed = true;
                try {
                    BoltResultHandle resultHandle = spi.executeQuery(ctx.loginContext, statement, params, txTimeout, txMetadata);
                    this.startExecution(ctx, resultHandle);
                    failed = false;
                }
                finally {
                    if (!isPeriodicCommit) {
                        if (failed) {
                            this.closeTransaction(ctx, false);
                        }
                    } else {
                        ctx.currentTransaction = spi.beginTransaction(ctx.loginContext, txTimeout, txMetadata);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Bookmark streamResult(MutableTransactionState ctx, TransactionStateMachineSPI spi, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                try {
                    this.consumeResult(ctx, resultConsumer);
                    this.closeTransaction(ctx, true);
                    Bookmark bookmark = TransactionStateMachine.newestBookmark(spi);
                    return bookmark;
                }
                finally {
                    this.closeTransaction(ctx, false);
                }
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("No current transaction to commit."));
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) {
                ctx.currentResult = BoltResult.EMPTY;
                return AUTO_COMMIT;
            }
        }
        ,
        EXPLICIT_TRANSACTION{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, Bookmark bookmark, Duration txTimeout, Map<String, Object> txMetadata) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Nested transactions are not supported."));
            }

            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, Bookmark bookmark, Duration ignored1, Map<String, Object> ignored2) throws KernelException {
                Preconditions.checkState((ignored1 == null ? 1 : 0) != 0, (String)"Explicit Transaction should not run with tx_timeout");
                Preconditions.checkState((ignored2 == null ? 1 : 0) != 0, (String)"Explicit Transaction should not run with tx_metadata");
                if (statement.isEmpty()) {
                    statement = ctx.lastStatement;
                } else {
                    ctx.lastStatement = statement;
                }
                if (spi.isPeriodicCommit(statement)) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Executing queries that use periodic commit in an open transaction is not possible."));
                }
                BoltResultHandle resultHandle = spi.executeQuery(ctx.loginContext, statement, params, null, null);
                this.startExecution(ctx, resultHandle);
                return EXPLICIT_TRANSACTION;
            }

            @Override
            Bookmark streamResult(MutableTransactionState ctx, TransactionStateMachineSPI spi, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
                assert (ctx.currentResult != null);
                this.consumeResult(ctx, resultConsumer);
                return null;
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                this.closeTransaction(ctx, true);
                Bookmark bookmark = TransactionStateMachine.newestBookmark(spi);
                ctx.currentResult = new BookmarkResult(bookmark);
                return AUTO_COMMIT;
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                this.closeTransaction(ctx, false);
                ctx.currentResult = BoltResult.EMPTY;
                return AUTO_COMMIT;
            }
        };


        abstract State beginTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2, Bookmark var3, Duration var4, Map<String, Object> var5) throws KernelException;

        abstract State run(MutableTransactionState var1, TransactionStateMachineSPI var2, String var3, MapValue var4, Bookmark var5, Duration var6, Map<String, Object> var7) throws KernelException;

        abstract Bookmark streamResult(MutableTransactionState var1, TransactionStateMachineSPI var2, ThrowingConsumer<BoltResult, Exception> var3) throws Exception;

        abstract State commitTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        abstract State rollbackTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        void terminateQueryAndRollbackTransaction(MutableTransactionState ctx) throws TransactionFailureException {
            if (ctx.currentResultHandle != null) {
                ctx.currentResultHandle.terminate();
                ctx.currentResultHandle = null;
            }
            if (ctx.currentResult != null) {
                ctx.currentResult.close();
                ctx.currentResult = null;
            }
            this.closeTransaction(ctx, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeTransaction(MutableTransactionState ctx, boolean success) throws TransactionFailureException {
            KernelTransaction tx = ctx.currentTransaction;
            ctx.currentTransaction = null;
            if (tx != null) {
                try {
                    if (success) {
                        tx.success();
                    } else {
                        tx.failure();
                    }
                    if (tx.isOpen()) {
                        tx.close();
                    }
                }
                finally {
                    ctx.currentTransaction = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean consumeResult(MutableTransactionState ctx, ThrowingConsumer<BoltResult, Exception> resultConsumer) throws Exception {
            boolean success = false;
            try {
                resultConsumer.accept((Object)ctx.currentResult);
                success = true;
            }
            finally {
                ctx.currentResult.close();
                ctx.currentResult = null;
                if (ctx.currentResultHandle != null) {
                    ctx.currentResultHandle.close(success);
                    ctx.currentResultHandle = null;
                }
            }
            return success;
        }

        void startExecution(MutableTransactionState ctx, BoltResultHandle resultHandle) throws KernelException {
            ctx.currentResultHandle = resultHandle;
            try {
                ctx.currentResult = resultHandle.start();
            }
            catch (Throwable t) {
                ctx.currentResultHandle.close(false);
                ctx.currentResultHandle = null;
                throw t;
            }
        }
    }
}

