/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends FailSafeBoltStateMachineState {
    protected BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        if (message instanceof PullAllMessage) {
            return this.processStreamResultMessage(true, context);
        }
        if (message instanceof DiscardAllMessage) {
            return this.processStreamResultMessage(false, context);
        }
        return null;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    abstract BoltStateMachineState processStreamResultMessage(boolean var1, StateMachineContext var2) throws Throwable;

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

