/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.storageengine.api.StoreId;

public class ClusterMember {
    private final InstanceId instanceId;
    private final Map<String, URI> roles;
    private final StoreId storeId;
    private final boolean alive;

    public ClusterMember(InstanceId instanceId) {
        this(instanceId, Collections.emptyMap(), StoreId.DEFAULT, true);
    }

    public ClusterMember(InstanceId instanceId, Map<String, URI> roles, StoreId storeId, boolean alive) {
        this.instanceId = instanceId;
        this.roles = roles;
        this.storeId = storeId;
        this.alive = alive;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public URI getHAUri() {
        URI haURI = this.roles.get("master");
        if (haURI == null) {
            haURI = this.roles.get("slave");
        }
        return haURI;
    }

    public String getHARole() {
        if (this.roles.containsKey("master")) {
            return "master";
        }
        if (this.roles.containsKey("slave")) {
            return "slave";
        }
        return "UNKNOWN";
    }

    public boolean hasRole(String role) {
        return this.roles.containsKey(role);
    }

    public Iterable<String> getRoles() {
        return this.roles.keySet();
    }

    public Iterable<URI> getRoleURIs() {
        return this.roles.values();
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public boolean isAlive() {
        return this.alive;
    }

    ClusterMember availableAs(String role, URI roleUri, StoreId storeId) {
        HashMap<String, URI> copy = new HashMap<String, URI>(this.roles);
        if (role.equals("master")) {
            copy.remove("slave");
        } else if (role.equals("slave")) {
            copy.remove("master");
            copy.remove("backup");
        }
        copy.put(role, roleUri);
        return new ClusterMember(this.instanceId, copy, storeId, this.alive);
    }

    ClusterMember unavailable() {
        return new ClusterMember(this.instanceId, Collections.emptyMap(), this.storeId, this.alive);
    }

    ClusterMember unavailableAs(String role) {
        return new ClusterMember(this.instanceId, MapUtil.copyAndRemove(this.roles, (Object)role), this.storeId, this.alive);
    }

    ClusterMember alive() {
        return new ClusterMember(this.instanceId, this.roles, this.storeId, true);
    }

    ClusterMember failed() {
        return new ClusterMember(this.instanceId, this.roles, this.storeId, false);
    }

    public String toString() {
        return "ClusterMember{instanceId=" + this.instanceId + ", roles=" + this.roles + ", storeId=" + this.storeId + ", alive=" + this.alive + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMember that = (ClusterMember)o;
        return this.instanceId.equals((Object)that.instanceId);
    }

    public int hashCode() {
        return this.instanceId.hashCode();
    }
}

