/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterTransactionCommitProcess;
import org.neo4j.kernel.ha.SlaveTransactionCommitProcess;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngine;

public class CommitProcessSwitcher
extends AbstractComponentSwitcher<TransactionCommitProcess> {
    private final TransactionPropagator txPropagator;
    private final Master master;
    private final RequestContextFactory requestContextFactory;
    private final DependencyResolver dependencyResolver;
    private final MasterTransactionCommitProcess.Monitor monitor;
    private final String activeDatabaseName;

    public CommitProcessSwitcher(TransactionPropagator txPropagator, Master master, DelegateInvocationHandler<TransactionCommitProcess> delegate, RequestContextFactory requestContextFactory, Monitors monitors, DependencyResolver dependencyResolver, Config config) {
        super(delegate);
        this.txPropagator = txPropagator;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.dependencyResolver = dependencyResolver;
        this.monitor = (MasterTransactionCommitProcess.Monitor)monitors.newMonitor(MasterTransactionCommitProcess.Monitor.class, new String[0]);
        this.activeDatabaseName = (String)config.get(GraphDatabaseSettings.active_database);
    }

    @Override
    protected TransactionCommitProcess getSlaveImpl() {
        return new SlaveTransactionCommitProcess(this.master, this.requestContextFactory);
    }

    @Override
    protected TransactionCommitProcess getMasterImpl() {
        GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)((DatabaseManager)this.dependencyResolver.resolveDependency(DatabaseManager.class)).getDatabaseFacade(this.activeDatabaseName).get();
        DependencyResolver databaseResolver = databaseFacade.getDependencyResolver();
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)databaseResolver.resolveDependency(TransactionAppender.class), (StorageEngine)databaseResolver.resolveDependency(StorageEngine.class));
        IntegrityValidator validator = (IntegrityValidator)databaseResolver.resolveDependency(IntegrityValidator.class);
        return new MasterTransactionCommitProcess((TransactionCommitProcess)commitProcess, this.txPropagator, validator, this.monitor);
    }
}

