/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.com.storecopy.StoreUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.BranchedStoreInfo;

public final class BranchedStoreBean
extends ManagementBeanProvider {
    public BranchedStoreBean() {
        super(BranchedStore.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return OperationalMode.ha == ((DatabaseInfo)management.resolveDependency(DatabaseInfo.class)).operationalMode;
    }

    private static class BranchedStoreImpl
    extends Neo4jMBean
    implements BranchedStore {
        private final FileSystemAbstraction fileSystem;
        private final PageCache pageCache;
        private KernelData kernelData;

        BranchedStoreImpl(ManagementData management) {
            this(management, false);
        }

        BranchedStoreImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.kernelData = management.getKernelData();
            this.fileSystem = BranchedStoreImpl.getFilesystem(this.kernelData);
            this.pageCache = BranchedStoreImpl.getPageCache(this.kernelData);
        }

        public BranchedStoreInfo[] getBranchedStores() {
            DatabaseLayout databaseLayout = this.kernelData.getDataSourceManager().getDataSource().getDatabaseLayout();
            File databaseDirectory = databaseLayout.databaseDirectory();
            if (databaseDirectory == null) {
                return new BranchedStoreInfo[0];
            }
            LinkedList<BranchedStoreInfo> toReturn = new LinkedList<BranchedStoreInfo>();
            File[] files = this.fileSystem.listFiles(StoreUtil.getBranchedDataRootDirectory((File)databaseDirectory));
            if (files != null) {
                for (File branchDirectory : files) {
                    if (!branchDirectory.isDirectory()) continue;
                    toReturn.add(this.parseBranchedStore(branchDirectory));
                }
            }
            return toReturn.toArray(new BranchedStoreInfo[toReturn.size()]);
        }

        private BranchedStoreInfo parseBranchedStore(File branchedDatabase) {
            try {
                File neoStoreFile = DatabaseLayout.of((File)branchedDatabase).metadataStore();
                long txId = MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID);
                long timestamp = Long.parseLong(branchedDatabase.getName());
                long branchedStoreSize = FileUtils.size((FileSystemAbstraction)this.fileSystem, (File)branchedDatabase);
                return new BranchedStoreInfo(branchedDatabase.getName(), txId, timestamp, branchedStoreSize);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read branched neostore", e);
            }
        }

        private static PageCache getPageCache(KernelData kernelData) {
            return kernelData.getPageCache();
        }

        private static FileSystemAbstraction getFilesystem(KernelData kernelData) {
            return kernelData.getFilesystemAbstraction();
        }
    }
}

