/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.core;

import com.neo4j.causalclustering.discovery.SslDiscoveryServiceFactory;
import com.neo4j.causalclustering.handlers.SecurePipelineFactory;
import com.neo4j.commercial.edition.CommercialEditionModule;
import com.neo4j.dbms.database.MultiDatabaseManager;
import com.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import com.neo4j.kernel.impl.transaction.stats.GlobalTransactionStats;
import java.time.Clock;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.handlers.DuplexPipelineWrapperFactory;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.internal.LogService;
import org.neo4j.ssl.SslPolicy;

public class CommercialCoreEditionModule
extends EnterpriseCoreEditionModule {
    private final GlobalTransactionStats globalTransactionStats = new GlobalTransactionStats();

    CommercialCoreEditionModule(PlatformModule platformModule, SslDiscoveryServiceFactory discoveryServiceFactory) {
        super(platformModule, (DiscoveryServiceFactory)discoveryServiceFactory);
        this.initGlobalGuard((Clock)platformModule.clock, platformModule.logging);
    }

    protected ClusteringModule getClusteringModule(PlatformModule platformModule, DiscoveryServiceFactory discoveryServiceFactory, ClusterStateDirectory clusterStateDirectory, IdentityModule identityModule, Dependencies dependencies, DatabaseLayout databaseLayout) {
        SslPolicyLoader sslPolicyFactory = (SslPolicyLoader)dependencies.satisfyDependency((Object)SslPolicyLoader.create((Config)this.config, (LogProvider)this.logProvider));
        SslPolicy clusterSslPolicy = sslPolicyFactory.getPolicy((String)this.config.get(CausalClusteringSettings.ssl_policy));
        if (discoveryServiceFactory instanceof SslDiscoveryServiceFactory) {
            ((SslDiscoveryServiceFactory)discoveryServiceFactory).setSslPolicy(clusterSslPolicy);
        }
        return new ClusteringModule(discoveryServiceFactory, identityModule.myself(), platformModule, clusterStateDirectory.get(), databaseLayout, this.globalAvailabilityGuard);
    }

    public DatabaseManager createDatabaseManager(GraphDatabaseFacade graphDatabaseFacade, PlatformModule platform, AbstractEditionModule edition, Procedures procedures, Logger msgLog) {
        return new MultiDatabaseManager(platform, edition, procedures, msgLog, graphDatabaseFacade);
    }

    public void createDatabases(DatabaseManager databaseManager, Config config) {
        CommercialEditionModule.createCommercialEditionDatabases(databaseManager, config);
    }

    protected DuplexPipelineWrapperFactory pipelineWrapperFactory() {
        return new SecurePipelineFactory();
    }

    public DatabaseTransactionStats createTransactionMonitor() {
        return this.globalTransactionStats.createDatabaseTransactionMonitor();
    }

    public TransactionCounters globalTransactionCounter() {
        return this.globalTransactionStats;
    }

    public AvailabilityGuard getGlobalAvailabilityGuard(Clock clock, LogService logService, Config config) {
        this.initGlobalGuard(clock, logService);
        return this.globalAvailabilityGuard;
    }

    public DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(String databaseName, Clock clock, LogService logService, Config config) {
        return ((CompositeDatabaseAvailabilityGuard)this.getGlobalAvailabilityGuard(clock, logService, config)).createDatabaseAvailabilityGuard(databaseName);
    }

    public void createSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.createEnterpriseSecurityModule((AbstractEditionModule)this, (PlatformModule)platformModule, (Procedures)procedures);
    }

    private void initGlobalGuard(Clock clock, LogService logService) {
        if (this.globalAvailabilityGuard == null) {
            this.globalAvailabilityGuard = new CompositeDatabaseAvailabilityGuard(clock, logService);
        }
    }
}

