/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.commercial.edition;

import com.neo4j.dbms.database.MultiDatabaseManager;
import com.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import com.neo4j.kernel.impl.transaction.stats.GlobalTransactionStats;
import com.neo4j.security.configuration.CommercialSecuritySettings;
import java.time.Clock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.provider.EnterpriseNoAuthSecurityProvider;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.internal.LogService;

public class CommercialEditionModule
extends EnterpriseEditionModule {
    private final GlobalTransactionStats globalTransactionStats = new GlobalTransactionStats();

    public CommercialEditionModule(PlatformModule platformModule) {
        super(platformModule);
        this.initGlobalGuard((Clock)platformModule.clock, platformModule.logging);
    }

    protected Function<String, TokenHolders> createTokenHolderProvider(PlatformModule platform) {
        Config config = platform.config;
        return databaseName -> {
            DatabaseManager databaseManager = (DatabaseManager)platform.dependencies.resolveDependency(DatabaseManager.class);
            Supplier<Kernel> kernelSupplier = () -> {
                GraphDatabaseFacade facade = (GraphDatabaseFacade)databaseManager.getDatabaseFacade(databaseName).orElseThrow(() -> new IllegalStateException(String.format("Database %s not found.", databaseName)));
                return (Kernel)facade.getDependencyResolver().resolveDependency(Kernel.class);
            };
            return new TokenHolders((TokenHolder)new DelegatingTokenHolder(CommercialEditionModule.createPropertyKeyCreator((Config)config, kernelSupplier), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder(CommercialEditionModule.createLabelIdCreator((Config)config, kernelSupplier), "Label"), (TokenHolder)new DelegatingTokenHolder(CommercialEditionModule.createRelationshipTypeCreator((Config)config, kernelSupplier), "RelationshipType"));
        };
    }

    public DatabaseManager createDatabaseManager(GraphDatabaseFacade graphDatabaseFacade, PlatformModule platform, AbstractEditionModule edition, Procedures procedures, Logger msgLog) {
        return new MultiDatabaseManager(platform, edition, procedures, msgLog, graphDatabaseFacade);
    }

    public void createDatabases(DatabaseManager databaseManager, Config config) {
        CommercialEditionModule.createCommercialEditionDatabases(databaseManager, config);
    }

    public static void createCommercialEditionDatabases(DatabaseManager databaseManager, Config config) {
        if (CommercialSecuritySettings.isSystemDatabaseEnabled((Config)config)) {
            databaseManager.createDatabase("system.db");
        }
        CommercialEditionModule.createConfiguredDatabases(databaseManager, config);
    }

    private static void createConfiguredDatabases(DatabaseManager databaseManager, Config config) {
        databaseManager.createDatabase((String)config.get(GraphDatabaseSettings.active_database));
    }

    public DatabaseTransactionStats createTransactionMonitor() {
        return this.globalTransactionStats.createDatabaseTransactionMonitor();
    }

    public TransactionCounters globalTransactionCounter() {
        return this.globalTransactionStats;
    }

    public AvailabilityGuard getGlobalAvailabilityGuard(Clock clock, LogService logService, Config config) {
        this.initGlobalGuard(clock, logService);
        return this.globalAvailabilityGuard;
    }

    public DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(String databaseName, Clock clock, LogService logService, Config config) {
        return ((CompositeDatabaseAvailabilityGuard)this.getGlobalAvailabilityGuard(clock, logService, config)).createDatabaseAvailabilityGuard(databaseName);
    }

    public void createSecurityModule(PlatformModule platformModule, Procedures procedures) {
        CommercialEditionModule.createCommercialSecurityModule((AbstractEditionModule)this, platformModule, procedures);
    }

    private static void createCommercialSecurityModule(AbstractEditionModule editionModule, PlatformModule platformModule, Procedures procedures) {
        EnterpriseNoAuthSecurityProvider securityProvider;
        if (((Boolean)platformModule.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            SecurityModule securityModule = CommercialEditionModule.setupSecurityModule((PlatformModule)platformModule, (AbstractEditionModule)editionModule, (Log)platformModule.logging.getUserLog(EnterpriseEditionModule.class), (Procedures)procedures, (String)"commercial-security-module");
            platformModule.life.add((Lifecycle)securityModule);
            securityProvider = securityModule;
        } else {
            securityProvider = EnterpriseNoAuthSecurityProvider.INSTANCE;
        }
        editionModule.setSecurityProvider((SecurityProvider)securityProvider);
    }

    private void initGlobalGuard(Clock clock, LogService logService) {
        if (this.globalAvailabilityGuard == null) {
            this.globalAvailabilityGuard = new CompositeDatabaseAvailabilityGuard(clock, logService);
        }
    }
}

