/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.commercial.edition.factory;

import com.neo4j.commercial.edition.CommercialGraphDatabase;
import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;

public class CommercialGraphDatabaseFactory
extends EnterpriseGraphDatabaseFactory {
    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(File storeDir, GraphDatabaseFactoryState state) {
        return new CommercialDatabaseCreator(storeDir, state);
    }

    private static class CommercialDatabaseCreator
    implements GraphDatabaseBuilder.DatabaseCreator {
        private final File storeDir;
        private final GraphDatabaseFactoryState state;

        CommercialDatabaseCreator(File storeDir, GraphDatabaseFactoryState state) {
            this.storeDir = storeDir;
            this.state = state;
        }

        public GraphDatabaseService newDatabase(Config config) {
            File absoluteStoreDir = this.storeDir.getAbsoluteFile();
            File databasesRoot = absoluteStoreDir.getParentFile();
            config.augment(GraphDatabaseSettings.active_database, absoluteStoreDir.getName());
            config.augment(GraphDatabaseSettings.databases_root_path, databasesRoot.getAbsolutePath());
            return new CommercialGraphDatabase(databasesRoot, config, this.state.databaseDependencies());
        }
    }
}

