/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.dbms.database;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.facade.spi.ClassicCoreSPI;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.DataSourceModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Logger;

public class MultiDatabaseManager
extends LifecycleAdapter
implements DatabaseManager {
    private final CopyOnWriteHashMap<String, GraphDatabaseFacade> databaseMap = new CopyOnWriteHashMap();
    private final PlatformModule platform;
    private final AbstractEditionModule edition;
    private final Procedures procedures;
    private final Logger log;
    private final GraphDatabaseFacade graphDatabaseFacade;

    public MultiDatabaseManager(PlatformModule platform, AbstractEditionModule edition, Procedures procedures, Logger log, GraphDatabaseFacade graphDatabaseFacade) {
        this.platform = platform;
        this.edition = edition;
        this.procedures = procedures;
        this.log = log;
        this.graphDatabaseFacade = graphDatabaseFacade;
    }

    public GraphDatabaseFacade createDatabase(String databaseName) {
        Objects.requireNonNull(databaseName, "Database name should be not null");
        this.log.log("Creating '%s' database.", new Object[]{databaseName});
        GraphDatabaseFacade facade = ((String)this.platform.config.get(GraphDatabaseSettings.active_database)).equals(databaseName) ? this.graphDatabaseFacade : new GraphDatabaseFacade();
        DataSourceModule dataSource = new DataSourceModule(databaseName, this.platform, this.edition, this.procedures, facade);
        ClassicCoreSPI spi = new ClassicCoreSPI(this.platform, dataSource, this.log, dataSource.coreAPIAvailabilityGuard, this.edition.getThreadToTransactionBridge());
        facade.init((GraphDatabaseFacade.SPI)spi, this.edition.getThreadToTransactionBridge(), this.platform.config, dataSource.neoStoreDataSource.getTokenHolders());
        this.platform.dataSourceManager.register(dataSource.neoStoreDataSource);
        this.databaseMap.put((Object)databaseName, (Object)facade);
        return facade;
    }

    public Optional<GraphDatabaseFacade> getDatabaseFacade(String name) {
        return Optional.ofNullable(this.databaseMap.get((Object)name));
    }

    public void shutdownDatabase(String databaseName) {
        GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)this.databaseMap.remove((Object)databaseName);
        if (databaseFacade != null) {
            this.shutdownDatabase(databaseName, databaseFacade);
        }
    }

    public void stop() throws Throwable {
        Throwable stopException = null;
        for (Map.Entry databaseFacade : this.databaseMap.entrySet()) {
            try {
                this.shutdownDatabase((String)databaseFacade.getKey(), (GraphDatabaseFacade)databaseFacade.getValue());
            }
            catch (Throwable t) {
                stopException = Exceptions.chain(stopException, (Throwable)t);
            }
        }
        this.databaseMap.clear();
        if (stopException != null) {
            throw stopException;
        }
    }

    private void shutdownDatabase(String databaseName, GraphDatabaseFacade databaseFacade) {
        this.log.log("Shutting down '%s' database.", new Object[]{databaseName});
        databaseFacade.shutdown();
    }

    public List<String> listDatabases() {
        ArrayList<String> databaseNames = new ArrayList<String>(this.databaseMap.keySet());
        databaseNames.sort(Comparator.naturalOrder());
        return databaseNames;
    }
}

