/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.MultiDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class ManualMultiDestination
extends MultiDestination {
    private static final InetSocketAddress[] EMPTY_DESTINATIONS = new InetSocketAddress[0];
    private InetSocketAddress[] destinations = EMPTY_DESTINATIONS;

    ManualMultiDestination() {
    }

    @Override
    boolean isManualControlMode() {
        return true;
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend) {
        int position = buffer.position();
        int minBytesSent = bytesToSend;
        for (InetSocketAddress destination : this.destinations) {
            minBytesSent = Math.min(minBytesSent, ManualMultiDestination.send(datagramChannel, buffer, channelEndpoint, bytesToSend, position, destination));
        }
        return minBytesSent;
    }

    @Override
    void addDestination(InetSocketAddress address) {
        int length = this.destinations.length;
        InetSocketAddress[] newElements = new InetSocketAddress[length + 1];
        System.arraycopy(this.destinations, 0, newElements, 0, length);
        newElements[length] = address;
        this.destinations = newElements;
    }

    @Override
    void removeDestination(InetSocketAddress address) {
        boolean found = false;
        int index = 0;
        for (InetSocketAddress destination : this.destinations) {
            if (destination.equals(address)) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            InetSocketAddress[] oldElements = this.destinations;
            int length = oldElements.length;
            InetSocketAddress[] newElements = new InetSocketAddress[length - 1];
            int j = 0;
            for (int i = 0; i < length; ++i) {
                if (index == i) continue;
                newElements[j++] = oldElements[i];
            }
            this.destinations = newElements;
        }
    }
}

