/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleRepository;

public abstract class AbstractRoleRepository
extends LifecycleAdapter
implements RoleRepository {
    private final Map<String, RoleRecord> rolesByName = new ConcurrentHashMap<String, RoleRecord>();
    private final Map<String, SortedSet<String>> rolesByUsername = new ConcurrentHashMap<String, SortedSet<String>>();
    protected volatile List<RoleRecord> roles = new ArrayList<RoleRecord>();
    protected AtomicLong lastLoaded = new AtomicLong(0L);
    private final Pattern roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");

    @Override
    public void clear() {
        this.roles.clear();
        this.rolesByName.clear();
        this.rolesByUsername.clear();
    }

    @Override
    public RoleRecord getRoleByName(String roleName) {
        return roleName == null ? null : this.rolesByName.get(roleName);
    }

    @Override
    public Set<String> getRoleNamesByUsername(String username) {
        Set<String> roleNames = (Set<String>)this.rolesByUsername.get(username);
        return roleNames != null ? roleNames : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(RoleRecord role) throws InvalidArgumentsException, IOException {
        this.assertValidRoleName(role.name());
        AbstractRoleRepository abstractRoleRepository = this;
        synchronized (abstractRoleRepository) {
            for (RoleRecord other : this.roles) {
                if (!other.name().equals(role.name())) continue;
                throw new InvalidArgumentsException("The specified role '" + role.name() + "' already exists.");
            }
            this.roles.add(role);
            this.persistRoles();
            this.rolesByName.put(role.name(), role);
            this.populateUserMap(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoles(ListSnapshot<RoleRecord> rolesSnapshot) throws InvalidArgumentsException {
        for (RoleRecord role : rolesSnapshot.values()) {
            this.assertValidRoleName(role.name());
        }
        AbstractRoleRepository abstractRoleRepository = this;
        synchronized (abstractRoleRepository) {
            this.roles.clear();
            this.roles.addAll(rolesSnapshot.values());
            this.lastLoaded.set(rolesSnapshot.timestamp());
            MapUtil.trimToList(this.rolesByName, this.roles, RoleRecord::name);
            MapUtil.trimToFlattenedList(this.rolesByUsername, this.roles, r -> r.users().stream());
            for (RoleRecord role : this.roles) {
                this.rolesByName.put(role.name(), role);
                this.populateUserMap(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RoleRecord existingRole, RoleRecord updatedRole) throws ConcurrentModificationException, IOException {
        if (!existingRole.name().equals(updatedRole.name())) {
            throw new IllegalArgumentException("The attempt to update the role from '" + existingRole.name() + "' to '" + updatedRole.name() + "' failed. Changing a roles name is not allowed.");
        }
        AbstractRoleRepository abstractRoleRepository = this;
        synchronized (abstractRoleRepository) {
            ArrayList<RoleRecord> newRoles = new ArrayList<RoleRecord>();
            boolean foundRole = false;
            for (RoleRecord other : this.roles) {
                if (other.equals(existingRole)) {
                    foundRole = true;
                    newRoles.add(updatedRole);
                    continue;
                }
                newRoles.add(other);
            }
            if (!foundRole) {
                throw new ConcurrentModificationException();
            }
            this.roles = newRoles;
            this.persistRoles();
            this.rolesByName.put(updatedRole.name(), updatedRole);
            this.removeFromUserMap(existingRole);
            this.populateUserMap(updatedRole);
        }
    }

    @Override
    public synchronized boolean delete(RoleRecord role) throws IOException {
        boolean foundRole = false;
        ArrayList<RoleRecord> newRoles = new ArrayList<RoleRecord>();
        for (RoleRecord other : this.roles) {
            if (other.name().equals(role.name())) {
                foundRole = true;
                continue;
            }
            newRoles.add(other);
        }
        if (foundRole) {
            this.roles = newRoles;
            this.persistRoles();
            this.rolesByName.remove(role.name());
        }
        this.removeFromUserMap(role);
        return foundRole;
    }

    @Override
    public synchronized int numberOfRoles() {
        return this.roles.size();
    }

    @Override
    public void assertValidRoleName(String name) throws InvalidArgumentsException {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentsException("The provided role name is empty.");
        }
        if (!this.roleNamePattern.matcher(name).matches()) {
            throw new InvalidArgumentsException("Role name '" + name + "' contains illegal characters. Use simple ascii characters and numbers.");
        }
    }

    @Override
    public synchronized void removeUserFromAllRoles(String username) throws ConcurrentModificationException, IOException {
        Set roles = this.rolesByUsername.get(username);
        if (roles != null) {
            ArrayList rolesToRemoveFrom = new ArrayList(roles);
            for (String roleName : rolesToRemoveFrom) {
                RoleRecord role = this.rolesByName.get(roleName);
                RoleRecord newRole = role.augment().withoutUser(username).build();
                this.update(role, newRole);
            }
        }
    }

    @Override
    public synchronized Set<String> getAllRoleNames() {
        return this.roles.stream().map(RoleRecord::name).collect(Collectors.toSet());
    }

    @Override
    public void purge() throws IOException {
        this.clear();
    }

    @Override
    public void markAsMigrated() throws IOException {
        this.clear();
    }

    protected abstract void persistRoles() throws IOException;

    protected abstract ListSnapshot<RoleRecord> readPersistedRoles() throws IOException;

    protected void populateUserMap(RoleRecord role) {
        for (String username : role.users()) {
            SortedSet memberOfRoles = this.rolesByUsername.computeIfAbsent(username, k -> new ConcurrentSkipListSet());
            memberOfRoles.add(role.name());
        }
    }

    protected void removeFromUserMap(RoleRecord role) {
        for (String username : role.users()) {
            SortedSet<String> memberOfRoles = this.rolesByUsername.get(username);
            if (memberOfRoles == null) continue;
            memberOfRoles.remove(role.name());
        }
    }
}

