/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.util.ByteSource;

public class SecureHasher {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final int HASH_ITERATIONS = 1024;
    private static final int SALT_BYTES_SIZE = 32;
    private RandomNumberGenerator randomNumberGenerator;
    private HashedCredentialsMatcher hashedCredentialsMatcher;
    private Map<Integer, HashedCredentialsMatcher> hashedCredentialsMatchers;

    private RandomNumberGenerator getRandomNumberGenerator() {
        if (this.randomNumberGenerator == null) {
            this.randomNumberGenerator = new SecureRandomNumberGenerator();
        }
        return this.randomNumberGenerator;
    }

    public SimpleHash hash(byte[] source) {
        ByteSource salt = this.generateRandomSalt(32);
        return new SimpleHash(HASH_ALGORITHM, (Object)source, (Object)salt, 1024);
    }

    public HashedCredentialsMatcher getHashedCredentialsMatcher() {
        if (this.hashedCredentialsMatcher == null) {
            this.hashedCredentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
            this.hashedCredentialsMatcher.setHashIterations(1024);
        }
        return this.hashedCredentialsMatcher;
    }

    public HashedCredentialsMatcher getHashedCredentialsMatcherWithIterations(int iterations) {
        HashedCredentialsMatcher matcher;
        if (this.hashedCredentialsMatchers == null) {
            this.hashedCredentialsMatchers = new HashMap<Integer, HashedCredentialsMatcher>();
        }
        if ((matcher = this.hashedCredentialsMatchers.get(iterations)) == null) {
            matcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
            matcher.setHashIterations(iterations);
            this.hashedCredentialsMatchers.put(iterations, matcher);
        }
        return matcher;
    }

    private ByteSource generateRandomSalt(int bytesSize) {
        return this.getRandomNumberGenerator().nextBytes(bytesSize);
    }
}

