/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthToken;

public class PluginApiAuthToken
implements AuthToken {
    private final String principal;
    private final char[] credentials;
    private final Map<String, Object> parameters;

    private PluginApiAuthToken(String principal, char[] credentials, Map<String, Object> parameters) {
        this.principal = principal;
        this.credentials = credentials;
        this.parameters = parameters;
    }

    public String principal() {
        return this.principal;
    }

    public char[] credentials() {
        return this.credentials;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    void clearCredentials() {
        if (this.credentials != null) {
            Arrays.fill(this.credentials, '\u0000');
        }
    }

    public static PluginApiAuthToken of(String principal, char[] credentials, Map<String, Object> parameters) {
        return new PluginApiAuthToken(principal, credentials, parameters);
    }

    public static PluginApiAuthToken createFromMap(Map<String, Object> authTokenMap) throws InvalidAuthTokenException {
        String scheme = org.neo4j.kernel.api.security.AuthToken.safeCast((String)"scheme", authTokenMap);
        String principal = org.neo4j.kernel.api.security.AuthToken.safeCast((String)"principal", authTokenMap);
        byte[] credentials = null;
        if (scheme.equals("basic")) {
            credentials = org.neo4j.kernel.api.security.AuthToken.safeCastCredentials((String)"credentials", authTokenMap);
        } else {
            Object credentialsObject = authTokenMap.get("credentials");
            if (credentialsObject instanceof byte[]) {
                credentials = (byte[])credentialsObject;
            }
        }
        Map parameters = org.neo4j.kernel.api.security.AuthToken.safeCastMap((String)"parameters", authTokenMap);
        return PluginApiAuthToken.of(principal, credentials != null ? StandardCharsets.UTF_8.decode(ByteBuffer.wrap(credentials)).array() : null, parameters);
    }
}

