/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.kernel.availability;

import java.time.Clock;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.logging.internal.LogService;

public class CompositeDatabaseAvailabilityGuard
implements AvailabilityGuard {
    private final Clock clock;
    private final LogService logService;
    private final CopyOnWriteArrayList<DatabaseAvailabilityGuard> guards = new CopyOnWriteArrayList();

    public CompositeDatabaseAvailabilityGuard(Clock clock, LogService logService) {
        this.clock = clock;
        this.logService = logService;
    }

    public DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(String databaseName) {
        DatabaseAvailabilityGuard guard = new DatabaseAvailabilityGuard(databaseName, this.clock, this.logService.getInternalLog(DatabaseAvailabilityGuard.class));
        this.guards.add(guard);
        return guard;
    }

    public void require(AvailabilityRequirement requirement) {
        this.guards.forEach(guard -> guard.require(requirement));
    }

    public void fulfill(AvailabilityRequirement requirement) {
        this.guards.forEach(guard -> guard.fulfill(requirement));
    }

    public void shutdown() {
        this.guards.forEach(DatabaseAvailabilityGuard::shutdown);
    }

    public boolean isAvailable() {
        return this.guards.stream().allMatch(DatabaseAvailabilityGuard::isAvailable);
    }

    public boolean isShutdown() {
        return this.guards.stream().anyMatch(DatabaseAvailabilityGuard::isShutdown);
    }

    public boolean isAvailable(long millis) {
        long totalWait = 0L;
        for (DatabaseAvailabilityGuard guard : this.guards) {
            long startMillis = this.clock.millis();
            if (!guard.isAvailable(Math.max(0L, millis - totalWait))) {
                return false;
            }
            if ((totalWait += this.clock.millis() - startMillis) <= millis) continue;
            return false;
        }
        return true;
    }

    public void checkAvailable() throws UnavailableException {
        for (DatabaseAvailabilityGuard guard : this.guards) {
            guard.checkAvailable();
        }
    }

    public void await(long millis) throws UnavailableException {
        long totalWait = 0L;
        for (DatabaseAvailabilityGuard guard : this.guards) {
            long startMillis = this.clock.millis();
            guard.await(Math.max(0L, millis - totalWait));
            if ((totalWait += this.clock.millis() - startMillis) <= millis) continue;
            throw new UnavailableException("Database is not available: " + this.describeGuards());
        }
    }

    public void addListener(AvailabilityListener listener) {
        this.guards.forEach(guard -> guard.addListener(listener));
    }

    public void removeListener(AvailabilityListener listener) {
        this.guards.forEach(guard -> guard.removeListener(listener));
    }

    private String describeGuards() {
        return this.guards.stream().map(DatabaseAvailabilityGuard::describeWhoIsBlocking).collect(Collectors.joining(", "));
    }
}

