/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;

class RelationshipTypeDistributionStorage {
    private final FileSystemAbstraction fs;
    private final File file;

    RelationshipTypeDistributionStorage(FileSystemAbstraction fs, File file) {
        this.fs = fs;
        this.file = file;
    }

    void store(DataStatistics distribution) throws IOException {
        try (PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fs.open(this.file, OpenMode.READ_WRITE));){
            channel.putLong(distribution.getNodeCount());
            channel.putLong(distribution.getPropertyCount());
            channel.putInt(distribution.getNumberOfRelationshipTypes());
            for (DataStatistics.RelationshipTypeCount entry : distribution) {
                channel.putInt(entry.getTypeId());
                channel.putLong(entry.getCount());
            }
        }
    }

    DataStatistics load() throws IOException {
        try (ReadAheadChannel channel = new ReadAheadChannel(this.fs.open(this.file, OpenMode.READ));){
            long nodeCount = channel.getLong();
            long propertyCount = channel.getLong();
            DataStatistics.RelationshipTypeCount[] entries = new DataStatistics.RelationshipTypeCount[channel.getInt()];
            for (int i = 0; i < entries.length; ++i) {
                int typeId = channel.getInt();
                long count = channel.getLong();
                entries[i] = new DataStatistics.RelationshipTypeCount(typeId, count);
            }
            DataStatistics dataStatistics = new DataStatistics(nodeCount, propertyCount, entries);
            return dataStatistics;
        }
    }

    void remove() {
        this.fs.deleteFile(this.file);
    }
}

