/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.unsafe.impl.batchimport;

import com.neo4j.unsafe.impl.batchimport.RelationshipTypeDistributionStorage;
import com.neo4j.unsafe.impl.batchimport.State;
import com.neo4j.unsafe.impl.batchimport.StateStorage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class RestartableParallelBatchImporter
implements BatchImporter {
    static final String FILE_NAME_STATE = "state";
    private static final String FILE_NAME_RELATIONSHIP_DISTRIBUTION = "relationship-type-distribution";
    private static final String STATE_NEW_IMPORT = "";
    private static final String STATE_INIT = "init";
    private static final String STATE_START = "start";
    private static final String STATE_DATA_IMPORT = "data-import";
    private static final String STATE_DATA_LINK = "data-link";
    private static final String STATE_DEFRAGMENT = "defragment";
    private final PageCache externalPageCache;
    private final File databaseDirectory;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final LogService logService;
    private final Config dbConfig;
    private final RecordFormats recordFormats;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final RelationshipTypeDistributionStorage dataStatisticsStorage;
    private final ImportLogic.Monitor monitor;
    private final JobScheduler jobScheduler;

    public RestartableParallelBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCache externalPageCache, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, ImportLogic.Monitor monitor, JobScheduler jobScheduler) {
        this.externalPageCache = externalPageCache;
        this.databaseDirectory = databaseLayout.databaseDirectory();
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
        this.monitor = monitor;
        this.dataStatisticsStorage = new RelationshipTypeDistributionStorage(fileSystem, new File(this.databaseDirectory, FILE_NAME_RELATIONSHIP_DISTRIBUTION));
        this.jobScheduler = jobScheduler;
    }

    public void doImport(Input input) throws IOException {
        try (BatchingNeoStores store = ImportLogic.instantiateNeoStores((FileSystemAbstraction)this.fileSystem, (File)this.databaseDirectory, (PageCache)this.externalPageCache, (RecordFormats)this.recordFormats, (Configuration)this.config, (LogService)this.logService, (AdditionalInitialIds)this.additionalInitialIds, (Config)this.dbConfig, (JobScheduler)this.jobScheduler);
             ImportLogic logic = new ImportLogic(this.databaseDirectory, this.fileSystem, store, this.config, this.logService, this.executionMonitor, this.recordFormats, this.monitor);){
            StateStorage stateStore = new StateStorage(this.fileSystem, new File(this.databaseDirectory, FILE_NAME_STATE));
            PrefetchingIterator<State> states = this.initializeStates(logic);
            Pair<String, byte[]> previousState = stateStore.get();
            RestartableParallelBatchImporter.fastForwardToLastCompletedState(store, stateStore, (String)previousState.first(), (byte[])previousState.other(), states);
            logic.initialize(input);
            this.runRemainingStates(store, stateStore, (byte[])previousState.other(), (Iterator<State>)states);
            logic.success();
        }
    }

    private PrefetchingIterator<State> initializeStates(final ImportLogic logic) {
        ArrayList<State> states = new ArrayList<State>();
        states.add(new State(STATE_INIT, (StoreType[])ArrayUtil.array((Object[])new StoreType[0]), (StoreType[])ArrayUtil.array((Object[])new StoreType[0])));
        states.add(new State(STATE_START, (StoreType[])ArrayUtil.array((Object[])new StoreType[]{StoreType.META_DATA}), (StoreType[])ArrayUtil.array((Object[])new StoreType[0])));
        states.add(new State(STATE_DATA_IMPORT, (StoreType[])ArrayUtil.array((Object[])new StoreType[]{StoreType.NODE, StoreType.NODE_LABEL, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME}), (StoreType[])ArrayUtil.array((Object[])new StoreType[0])){

            @Override
            void run(byte[] fromCheckPoint, State.CheckPointer checkPointer) throws IOException {
                logic.importNodes();
                logic.prepareIdMapper();
                logic.importRelationships();
            }

            @Override
            void save() throws IOException {
                RestartableParallelBatchImporter.this.dataStatisticsStorage.store((DataStatistics)logic.getState(DataStatistics.class));
            }

            @Override
            void load() throws IOException {
                logic.putState((Object)RestartableParallelBatchImporter.this.dataStatisticsStorage.load());
            }
        });
        states.add(new State(STATE_DATA_LINK, (StoreType[])ArrayUtil.array((Object[])new StoreType[0]), (StoreType[])ArrayUtil.array((Object[])new StoreType[]{StoreType.RELATIONSHIP_GROUP})){

            @Override
            void run(byte[] fromCheckPoint, State.CheckPointer checkPointer) {
                logic.calculateNodeDegrees();
                int type = 0;
                while (type != -1) {
                    type = logic.linkRelationships(type);
                }
            }
        });
        states.add(new State(STATE_DEFRAGMENT, (StoreType[])ArrayUtil.array((Object[])new StoreType[]{StoreType.RELATIONSHIP_GROUP}), (StoreType[])ArrayUtil.array((Object[])new StoreType[0])){

            @Override
            void run(byte[] fromCheckPoint, State.CheckPointer checkPointer) {
                logic.defragmentRelationshipGroups();
            }
        });
        states.add(new State(null, (StoreType[])ArrayUtil.array((Object[])new StoreType[0]), (StoreType[])ArrayUtil.array((Object[])new StoreType[0])){

            @Override
            void run(byte[] fromCheckPoint, State.CheckPointer checkPointer) {
                logic.buildCountsStore();
            }
        });
        return Iterators.prefetching(states.iterator());
    }

    private static void fastForwardToLastCompletedState(BatchingNeoStores store, StateStorage stateStore, String stateName, byte[] checkPoint, PrefetchingIterator<State> states) throws IOException {
        if (STATE_NEW_IMPORT.equals(stateName)) {
            store.createNew();
            stateStore.set(STATE_INIT, PropertyType.EMPTY_BYTE_ARRAY);
        } else {
            HashSet<StoreType> mainStoresToKeep = new HashSet<StoreType>();
            HashSet<StoreType> tempStoresToKeep = new HashSet<StoreType>();
            while (states.hasNext()) {
                State state = (State)states.peek();
                mainStoresToKeep.addAll(Arrays.asList(state.completesMainStoreTypes()));
                tempStoresToKeep.addAll(Arrays.asList(state.completesTempStoreTypes()));
                state.load();
                if (state.name().equals(stateName)) {
                    store.pruneAndOpenExistingStore(type -> mainStoresToKeep.contains(type), type -> tempStoresToKeep.contains(type));
                    if (checkPoint.length != 0) break;
                    states.next();
                    break;
                }
                states.next();
            }
        }
    }

    private void runRemainingStates(BatchingNeoStores store, StateStorage stateStore, byte[] checkPoint, Iterator<State> states) throws IOException {
        while (states.hasNext()) {
            State state = states.next();
            String stateName = state.name();
            state.run(checkPoint, cp -> this.writeState(store, stateStore, stateName, cp));
            state.save();
            checkPoint = PropertyType.EMPTY_BYTE_ARRAY;
            this.writeState(store, stateStore, stateName, PropertyType.EMPTY_BYTE_ARRAY);
        }
    }

    private void writeState(BatchingNeoStores store, StateStorage state, String stateName, byte[] checkPoint) throws IOException {
        store.flushAndForce();
        if (stateName != null) {
            state.set(stateName, checkPoint);
        } else {
            state.remove();
            this.dataStatisticsStorage.remove();
        }
    }

    private static byte[] intCheckPoint(int type) {
        byte[] checkPoint = new byte[4];
        ByteBuffer.wrap(checkPoint).putInt(type);
        return checkPoint;
    }
}

