/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.unsafe.impl.batchimport;

import com.neo4j.unsafe.impl.batchimport.ChannelUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class StateStorage {
    public static final String NO_STATE = "";
    public static final String INIT = "init";
    private final FileSystemAbstraction fs;
    private final File stateFile;
    private final File tempFile;

    public StateStorage(FileSystemAbstraction fs, File stateFile) {
        this.fs = fs;
        this.stateFile = stateFile;
        this.tempFile = new File(stateFile.getAbsolutePath() + ".tmp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<String, byte[]> get() throws IOException {
        try (ReadAheadChannel channel = new ReadAheadChannel(this.fs.open(this.stateFile, OpenMode.READ));){
            String name = ChannelUtils.readString((ReadableClosableChannel)channel);
            byte[] checkPoint = new byte[channel.getInt()];
            channel.get(checkPoint, checkPoint.length);
            Pair pair = Pair.of((Object)name, (Object)checkPoint);
            return pair;
        }
        catch (FileNotFoundException e) {
            return Pair.of((Object)NO_STATE, (Object)PropertyType.EMPTY_BYTE_ARRAY);
        }
        catch (ReadPastEndException e) {
            return Pair.of((Object)INIT, (Object)PropertyType.EMPTY_BYTE_ARRAY);
        }
    }

    public void set(String name, byte[] checkPoint) throws IOException {
        this.fs.mkdirs(this.tempFile.getParentFile());
        try (PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fs.open(this.tempFile, OpenMode.READ_WRITE));){
            ChannelUtils.writeString(name, (FlushableChannel)channel);
            channel.putInt(checkPoint.length);
            channel.put(checkPoint, checkPoint.length);
        }
        this.fs.renameFile(this.tempFile, this.stateFile, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
    }

    public void remove() throws IOException {
        this.fs.renameFile(this.stateFile, this.tempFile, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
        this.fs.deleteFileOrThrow(this.tempFile);
    }
}

