/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.index.impl.lucene.explicit.LuceneIndexImplementation;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.kernel.spi.explicitindex.IndexProviders;

public class LuceneKernelExtension
extends LifecycleAdapter {
    private final DatabaseLayout databaseLayout;
    private final Config config;
    private final Supplier<IndexConfigStore> indexStore;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final IndexProviders indexProviders;
    private final OperationalMode operationalMode;

    public LuceneKernelExtension(File databaseDirectory, Config config, Supplier<IndexConfigStore> indexStore, FileSystemAbstraction fileSystemAbstraction, IndexProviders indexProviders, OperationalMode operationalMode) {
        this.databaseLayout = DatabaseLayout.of((File)databaseDirectory);
        this.config = config;
        this.indexStore = indexStore;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.indexProviders = indexProviders;
        this.operationalMode = operationalMode;
    }

    public void init() {
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation(this.databaseLayout, this.config, this.indexStore, this.fileSystemAbstraction, this.operationalMode);
        this.indexProviders.registerIndexProvider("lucene", (IndexImplementation)indexImplementation);
    }

    public void shutdown() {
        this.indexProviders.unregisterIndexProvider("lucene");
    }
}

