/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.compiled.expressions;

import org.neo4j.cypher.internal.runtime.interpreted.ExecutionContext;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class CompiledHelpers {
    private CompiledHelpers() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static Value assertBooleanOrNoValue(AnyValue value) {
        if (value != Values.NO_VALUE && !(value instanceof BooleanValue)) {
            throw new CypherTypeException(String.format("Don't know how to treat a predicate: %s", value.toString()), null);
        }
        return (Value)value;
    }

    public static AnyValue loadVariable(ExecutionContext ctx, String name) {
        if (!ctx.contains((Object)name)) {
            throw new NotFoundException(String.format("Unknown variable `%s`.", name));
        }
        return (AnyValue)ctx.apply((Object)name);
    }
}

