/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import org.neo4j.helpers.Uris;

public class InstanceId
implements Externalizable,
Comparable<InstanceId> {
    public static final InstanceId NONE = new InstanceId(Integer.MIN_VALUE);
    private int serverId;

    public InstanceId() {
    }

    public InstanceId(int serverId) {
        this.serverId = serverId;
    }

    @Override
    public int compareTo(InstanceId o) {
        return Integer.compare(this.serverId, o.serverId);
    }

    public int hashCode() {
        return this.serverId;
    }

    public String toString() {
        return Integer.toString(this.serverId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceId instanceId1 = (InstanceId)o;
        return this.serverId == instanceId1.serverId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.serverId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.serverId = in.readInt();
    }

    public int toIntegerIndex() {
        return this.serverId;
    }

    public String instanceNameFromURI(URI member) {
        String name = member == null ? null : (String)Uris.parameter((String)"memberName").apply(member);
        return name == null ? this.toString() : name;
    }
}

