/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.client;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.Future;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterMonitor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.StateMachines;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.cluster.protocol.snapshot.SnapshotProvider;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.kernel.lifecycle.LifeSupport;

public class ClusterClient
implements ClusterMonitor,
Cluster,
AtomicBroadcast,
Snapshot,
Election,
BindingNotifier {
    private final Cluster cluster;
    private final AtomicBroadcast broadcast;
    private final Heartbeat heartbeat;
    private final Snapshot snapshot;
    private final Election election;
    private LifeSupport life;
    private ProtocolServer protocolServer;

    public ClusterClient(LifeSupport life, ProtocolServer protocolServer) {
        this.life = life;
        this.protocolServer = protocolServer;
        this.cluster = protocolServer.newClient(Cluster.class);
        this.broadcast = protocolServer.newClient(AtomicBroadcast.class);
        this.heartbeat = protocolServer.newClient(Heartbeat.class);
        this.snapshot = protocolServer.newClient(Snapshot.class);
        this.election = protocolServer.newClient(Election.class);
    }

    @Override
    public void broadcast(Payload payload) {
        this.broadcast.broadcast(payload);
    }

    @Override
    public void addAtomicBroadcastListener(AtomicBroadcastListener listener) {
        this.broadcast.addAtomicBroadcastListener(listener);
    }

    @Override
    public void removeAtomicBroadcastListener(AtomicBroadcastListener listener) {
        this.broadcast.removeAtomicBroadcastListener(listener);
    }

    @Override
    public void create(String clusterName) {
        this.cluster.create(clusterName);
    }

    @Override
    public Future<ClusterConfiguration> join(String clusterName, URI ... otherServerUrls) {
        return this.cluster.join(clusterName, otherServerUrls);
    }

    @Override
    public void leave() {
        this.cluster.leave();
    }

    @Override
    public void addClusterListener(ClusterListener listener) {
        this.cluster.addClusterListener(listener);
    }

    @Override
    public void removeClusterListener(ClusterListener listener) {
        this.cluster.removeClusterListener(listener);
    }

    @Override
    public void addHeartbeatListener(HeartbeatListener listener) {
        this.heartbeat.addHeartbeatListener(listener);
    }

    @Override
    public void removeHeartbeatListener(HeartbeatListener listener) {
        this.heartbeat.removeHeartbeatListener(listener);
    }

    @Override
    public void demote(InstanceId node) {
        this.election.demote(node);
    }

    @Override
    public void performRoleElections() {
        this.election.performRoleElections();
    }

    @Override
    public void setSnapshotProvider(SnapshotProvider snapshotProvider) {
        this.snapshot.setSnapshotProvider(snapshotProvider);
    }

    @Override
    public void refreshSnapshot() {
        this.snapshot.refreshSnapshot();
    }

    @Override
    public void addBindingListener(BindingListener bindingListener) {
        this.protocolServer.addBindingListener(bindingListener);
    }

    @Override
    public void removeBindingListener(BindingListener listener) {
        this.protocolServer.removeBindingListener(listener);
    }

    public void dumpDiagnostics(StringBuilder appendTo) {
        StateMachines stateMachines = this.protocolServer.getStateMachines();
        for (StateMachine stateMachine : stateMachines.getStateMachines()) {
            appendTo.append("   ").append(stateMachine.getMessageType().getSimpleName()).append(":").append(stateMachine.getState().toString()).append("\n");
        }
        appendTo.append("Current timeouts:\n");
        for (Map.Entry entry : stateMachines.getTimeouts().getTimeouts().entrySet()) {
            appendTo.append(entry.getKey().toString()).append(":").append(((Timeouts.Timeout)entry.getValue()).getTimeoutMessage().toString());
        }
    }

    public InstanceId getServerId() {
        return this.protocolServer.getServerId();
    }

    public URI getClusterServer() {
        return this.protocolServer.boundAt();
    }

    public void stop() {
        this.life.stop();
    }
}

