/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.com;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.neo4j.cluster.com.ChannelOpenFailedException;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageSender;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class NetworkSender
implements MessageSender,
Lifecycle {
    private ChannelGroup channels;
    private final Map<URI, ExecutorService> senderExecutors = new HashMap<URI, ExecutorService>();
    private final Set<URI> failedInstances = new HashSet<URI>();
    private ClientBootstrap clientBootstrap;
    private final Monitor monitor;
    private final Configuration config;
    private final NetworkReceiver receiver;
    private final Log msgLog;
    private URI me;
    private final Map<URI, Channel> connections = new ConcurrentHashMap<URI, Channel>();
    private final Listeners<NetworkChannelsListener> listeners = new Listeners();
    private volatile boolean paused;

    public NetworkSender(Monitor monitor, Configuration config, NetworkReceiver receiver, LogProvider logProvider) {
        this.monitor = monitor;
        this.config = config;
        this.receiver = receiver;
        this.msgLog = logProvider.getLog(this.getClass());
        this.me = URI.create("cluster://0.0.0.0:" + config.port());
        receiver.addNetworkChannelsListener(new NetworkReceiver.NetworkChannelsListener(){

            @Override
            public void listeningAt(URI me) {
                NetworkSender.this.me = me;
            }

            @Override
            public void channelOpened(URI to) {
            }

            @Override
            public void channelClosed(URI to) {
            }
        });
    }

    public void init() {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
    }

    public void start() {
        this.channels = new DefaultChannelGroup();
        this.clientBootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.daemon((String)"Cluster client boss", (NamedThreadFactory.Monitor)this.monitor)), (Executor)Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.daemon((String)"Cluster client worker", (NamedThreadFactory.Monitor)this.monitor)), 2));
        this.clientBootstrap.setOption("tcpNoDelay", (Object)Boolean.TRUE);
        this.clientBootstrap.setPipelineFactory((ChannelPipelineFactory)new NetworkNodePipelineFactory());
        this.msgLog.debug("Started NetworkSender for " + this.toString(this.config));
    }

    private String toString(Configuration config) {
        return "defaultPort:" + config.defaultPort() + ", port:" + config.port();
    }

    public void stop() throws Throwable {
        this.msgLog.debug("Shutting down NetworkSender");
        for (ExecutorService executorService : this.senderExecutors.values()) {
            executorService.shutdown();
        }
        long totalWaitTime = 0L;
        long maxWaitTime = TimeUnit.SECONDS.toMillis(5L);
        for (Map.Entry<URI, ExecutorService> entry : this.senderExecutors.entrySet()) {
            URI targetAddress = entry.getKey();
            ExecutorService executorService = entry.getValue();
            long start = System.currentTimeMillis();
            if (!executorService.awaitTermination(maxWaitTime - totalWaitTime, TimeUnit.MILLISECONDS)) {
                this.msgLog.warn("Could not shut down send executor towards: " + targetAddress);
                break;
            }
            totalWaitTime += System.currentTimeMillis() - start;
        }
        this.senderExecutors.clear();
        this.channels.close().awaitUninterruptibly();
        this.clientBootstrap.releaseExternalResources();
        this.msgLog.debug("Shutting down NetworkSender for " + this.toString(this.config) + " complete");
    }

    public void shutdown() {
    }

    @Override
    public void process(List<Message<? extends MessageType>> messages) {
        for (Message<? extends MessageType> message : messages) {
            try {
                this.process(message);
            }
            catch (Exception e) {
                this.msgLog.warn("Error sending message " + message + "(" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public boolean process(Message<? extends MessageType> message) {
        if (!this.paused) {
            if (message.hasHeader("to")) {
                this.send(message);
            } else {
                this.receiver.receive(message);
            }
        }
        return true;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private URI getURI(InetSocketAddress address) throws URISyntaxException {
        return new URI("cluster:/" + address);
    }

    private synchronized void send(Message message) {
        this.monitor.queuedMessage(message);
        URI to = URI.create(message.getHeader("to"));
        ExecutorService senderExecutor = this.senderExecutors.computeIfAbsent(to, t -> Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Cluster Sender " + t.toASCIIString(), (NamedThreadFactory.Monitor)this.monitor)));
        senderExecutor.submit(() -> {
            Channel channel = this.getChannel(to);
            try {
                if (channel == null) {
                    channel = this.openChannel(to);
                    this.openedChannel(to, channel);
                    this.failedInstances.remove(to);
                }
            }
            catch (Exception e) {
                if (!this.failedInstances.contains(to)) {
                    this.msgLog.warn(e.getMessage());
                    this.failedInstances.add(to);
                }
                return;
            }
            try {
                message.setHeader("from", this.me.toASCIIString());
                this.msgLog.debug("Sending to " + to + ": " + message);
                ChannelFuture future = channel.write((Object)message);
                future.addListener(future1 -> {
                    this.monitor.sentMessage(message);
                    if (!future1.isSuccess()) {
                        this.msgLog.debug("Unable to write " + message + " to " + future1.getChannel(), future1.getCause());
                        this.closedChannel(future1.getChannel());
                        this.send(message);
                    }
                });
            }
            catch (Exception e) {
                if (Exceptions.contains((Throwable)e, (Class[])new Class[]{ClosedChannelException.class})) {
                    this.msgLog.warn("Could not send message, because the connection has been closed.");
                } else {
                    this.msgLog.warn("Could not send message", (Throwable)e);
                }
                channel.close();
            }
        });
    }

    protected void openedChannel(URI uri, Channel ctxChannel) {
        this.connections.put(uri, ctxChannel);
        this.listeners.notify(listener -> listener.channelOpened(uri));
    }

    protected void closedChannel(Channel channelClosed) {
        URI to = null;
        for (Map.Entry<URI, Channel> uriChannelEntry : this.connections.entrySet()) {
            if (!uriChannelEntry.getValue().equals(channelClosed)) continue;
            to = uriChannelEntry.getKey();
            break;
        }
        if (to == null) {
            return;
        }
        this.connections.remove(to);
        URI uri = to;
        this.listeners.notify(listener -> listener.channelClosed(uri));
    }

    public Channel getChannel(URI uri) {
        return this.connections.get(uri);
    }

    public void addNetworkChannelsListener(NetworkChannelsListener listener) {
        this.listeners.add((Object)listener);
    }

    private Channel openChannel(URI clusterUri) {
        InetSocketAddress destination = new InetSocketAddress(clusterUri.getHost(), clusterUri.getPort() == -1 ? this.config.defaultPort() : clusterUri.getPort());
        InetSocketAddress origin = new InetSocketAddress(this.me.getHost(), 0);
        this.msgLog.info("Attempting to connect from " + origin + " to " + destination);
        ChannelFuture channelFuture = this.clientBootstrap.connect((SocketAddress)destination, (SocketAddress)origin);
        channelFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS);
        if (channelFuture.isSuccess()) {
            Channel channel = channelFuture.getChannel();
            this.msgLog.info("Connected from " + channel.getLocalAddress() + " to " + channel.getRemoteAddress());
            return channel;
        }
        Throwable cause = channelFuture.getCause();
        this.msgLog.info("Failed to connect to " + destination + " due to: " + cause);
        throw new ChannelOpenFailedException(cause);
    }

    private class NetworkMessageSender
    extends SimpleChannelHandler {
        private Throwable lastException;

        private NetworkMessageSender() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel ctxChannel = ctx.getChannel();
            NetworkSender.this.openedChannel(NetworkSender.this.getURI((InetSocketAddress)ctxChannel.getRemoteAddress()), ctxChannel);
            NetworkSender.this.channels.add((Object)ctxChannel);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NetworkSender.this.closedChannel(ctx.getChannel());
            NetworkSender.this.channels.remove((Object)ctx.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ConnectException || cause instanceof RejectedExecutionException || this.lastException == null || this.lastException.getClass().equals(cause.getClass()))) {
                NetworkSender.this.msgLog.error("Receive exception:", cause);
                this.lastException = cause;
            }
        }

        public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
            if (this.lastException != null) {
                NetworkSender.this.msgLog.error("Recovered from:", this.lastException);
                this.lastException = null;
            }
            super.writeComplete(ctx, e);
        }
    }

    private class NetworkNodePipelineFactory
    implements ChannelPipelineFactory {
        private NetworkNodePipelineFactory() {
        }

        public ChannelPipeline getPipeline() {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameEncoder", (ChannelHandler)new ObjectEncoder(2048));
            pipeline.addLast("sender", (ChannelHandler)new NetworkMessageSender());
            return pipeline;
        }
    }

    public static interface NetworkChannelsListener {
        public void channelOpened(URI var1);

        public void channelClosed(URI var1);
    }

    public static interface Configuration {
        public int defaultPort();

        public int port();
    }

    public static interface Monitor
    extends NamedThreadFactory.Monitor {
        public void queuedMessage(Message var1);

        public void sentMessage(Message var1);
    }
}

