/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;

public class PaxosInstance {
    PaxosInstanceStore store;
    InstanceId id;
    State state = State.empty;
    long ballot;
    List<URI> acceptors;
    List<ProposerMessage.PromiseState> promises = new ArrayList<ProposerMessage.PromiseState>();
    List<ProposerMessage.AcceptedState> accepts = new ArrayList<ProposerMessage.AcceptedState>();
    List<ProposerMessage.RejectAcceptState> rejectedAccepts = new ArrayList<ProposerMessage.RejectAcceptState>();
    Object value_1;
    long phase1Ballot;
    Object value_2;
    boolean clientValue;
    String conversationIdHeader;

    public PaxosInstance(PaxosInstanceStore store, InstanceId instanceId) {
        this.store = store;
        this.id = instanceId;
    }

    public boolean isState(State s) {
        return this.state.equals((Object)s);
    }

    public long getBallot() {
        return this.ballot;
    }

    public void propose(long ballot, List<URI> acceptors) {
        this.state = State.p1_pending;
        this.acceptors = acceptors;
        this.ballot = ballot;
    }

    public void phase1Timeout(long ballot) {
        this.ballot = ballot;
        this.promises.clear();
    }

    public void promise(ProposerMessage.PromiseState promiseState) {
        this.promises.add(promiseState);
        if (promiseState.getValue() != null && promiseState.getBallot() >= this.phase1Ballot) {
            this.value_1 = promiseState.getValue();
            this.phase1Ballot = promiseState.getBallot();
        }
    }

    public boolean isPromised(int minimumQuorumSize) {
        return this.promises.size() == minimumQuorumSize;
    }

    public void ready(Object value, boolean clientValue) {
        this.assertNotNull(value);
        this.state = State.p1_ready;
        this.promises.clear();
        this.value_1 = null;
        this.phase1Ballot = 0L;
        this.value_2 = value;
        this.clientValue = clientValue;
    }

    public void pending() {
        this.state = State.p2_pending;
    }

    public void phase2Timeout(long ballot) {
        this.state = State.p1_pending;
        this.ballot = ballot;
        this.promises.clear();
        this.value_1 = null;
        this.phase1Ballot = 0L;
    }

    public void accepted(ProposerMessage.AcceptedState acceptedState) {
        this.accepts.add(acceptedState);
    }

    public void rejected(ProposerMessage.RejectAcceptState rejectAcceptState) {
        this.rejectedAccepts.add(rejectAcceptState);
    }

    public boolean isAccepted(int minimumQuorumSize) {
        return this.accepts.size() + this.rejectedAccepts.size() == minimumQuorumSize && this.accepts.size() > this.rejectedAccepts.size();
    }

    public void closed(Object value, String conversationIdHeader) {
        this.assertNotNull(value);
        this.value_2 = value;
        this.state = State.closed;
        this.accepts.clear();
        this.rejectedAccepts.clear();
        this.acceptors = null;
        this.conversationIdHeader = conversationIdHeader;
    }

    private void assertNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
    }

    public void delivered() {
        this.state = State.delivered;
        this.store.delivered(this.id);
    }

    public List<URI> getAcceptors() {
        return this.acceptors;
    }

    public PaxosInstance snapshot(PaxosInstanceStore store) {
        PaxosInstance snap = new PaxosInstance(store, this.id);
        snap.state = this.state;
        snap.ballot = this.ballot;
        snap.acceptors = this.acceptors == null ? null : new ArrayList<URI>(this.acceptors);
        snap.promises = this.promises == null ? null : new ArrayList<ProposerMessage.PromiseState>(this.promises);
        snap.accepts = this.accepts == null ? null : new ArrayList<ProposerMessage.AcceptedState>(this.accepts);
        snap.rejectedAccepts = this.rejectedAccepts == null ? null : new ArrayList<ProposerMessage.RejectAcceptState>(this.rejectedAccepts);
        snap.value_1 = this.value_1;
        snap.phase1Ballot = this.phase1Ballot;
        snap.value_2 = this.value_2;
        snap.clientValue = this.clientValue;
        snap.conversationIdHeader = this.conversationIdHeader;
        return snap;
    }

    public String toString() {
        try {
            String toStringValue1 = null;
            if (this.value_1 != null) {
                toStringValue1 = this.value_1 instanceof Payload ? new AtomicBroadcastSerializer().receive((Payload)this.value_1).toString() : this.value_1.toString();
            }
            String toStringValue2 = null;
            if (this.value_2 != null) {
                toStringValue2 = this.value_2 instanceof Payload ? new AtomicBroadcastSerializer().receive((Payload)this.value_2).toString() : this.value_2.toString();
            }
            return "[id:" + this.id + " state:" + this.state.name() + " b:" + this.ballot + " v1:" + toStringValue1 + " v2:" + toStringValue2 + "]";
        }
        catch (Throwable e) {
            return "";
        }
    }

    static enum State {
        empty,
        p1_pending,
        p1_ready,
        p2_pending,
        closed,
        delivered;

    }
}

