/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.net.URI;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstance;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;

class ProposerContextImpl
extends AbstractContextImpl
implements ProposerContext {
    public static final int MAX_CONCURRENT_INSTANCES = 10;
    private final Deque<Message> pendingValues;
    private final Map<InstanceId, Message> bookedInstances;
    private final PaxosInstanceStore paxosInstances;
    private HeartbeatContext heartbeatContext;

    ProposerContextImpl(org.neo4j.cluster.InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, PaxosInstanceStore paxosInstances, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.paxosInstances = paxosInstances;
        this.heartbeatContext = heartbeatContext;
        this.pendingValues = new LinkedList<Message>();
        this.bookedInstances = new HashMap<InstanceId, Message>();
    }

    private ProposerContextImpl(org.neo4j.cluster.InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Deque<Message> pendingValues, Map<InstanceId, Message> bookedInstances, PaxosInstanceStore paxosInstances, HeartbeatContext heartbeatContext) {
        super(me, commonState, logging, timeouts);
        this.pendingValues = pendingValues;
        this.bookedInstances = bookedInstances;
        this.paxosInstances = paxosInstances;
        this.heartbeatContext = heartbeatContext;
    }

    @Override
    public InstanceId newInstanceId() {
        if (this.commonState.lastKnownLearnedInstanceInCluster() >= this.commonState.nextInstanceId()) {
            this.commonState.setNextInstanceId(this.commonState.lastKnownLearnedInstanceInCluster() + 1L);
        }
        return new InstanceId(this.commonState.getAndIncrementInstanceId());
    }

    @Override
    public void leave() {
        this.pendingValues.clear();
        this.bookedInstances.clear();
        this.commonState.setNextInstanceId(0L);
        this.paxosInstances.leave();
    }

    @Override
    public void bookInstance(InstanceId instanceId, Message message) {
        if (message.getPayload() == null) {
            throw new IllegalArgumentException("null payload for booking instance: " + message);
        }
        this.bookedInstances.put(instanceId, message);
    }

    @Override
    public PaxosInstance getPaxosInstance(InstanceId instanceId) {
        return this.paxosInstances.getPaxosInstance(instanceId);
    }

    @Override
    public void pendingValue(Message message) {
        this.pendingValues.offerFirst(message);
    }

    @Override
    public boolean hasPendingValues() {
        return !this.pendingValues.isEmpty();
    }

    @Override
    public Message popPendingValue() {
        return this.pendingValues.remove();
    }

    @Override
    public boolean canBookInstance() {
        return this.bookedInstances.size() < 10;
    }

    @Override
    public Message getBookedInstance(InstanceId id) {
        return this.bookedInstances.get(id);
    }

    @Override
    public Message<ProposerMessage> unbookInstance(InstanceId id) {
        return this.bookedInstances.remove(id);
    }

    @Override
    public int nrOfBookedInstances() {
        return this.bookedInstances.size();
    }

    @Override
    public List<URI> getAcceptors() {
        Iterable aliveMembers = Iterables.map(instanceId -> this.heartbeatContext.getUriForId((org.neo4j.cluster.InstanceId)instanceId), this.heartbeatContext.getAlive());
        return Iterables.asList((Iterable)Iterables.limit((int)((int)Math.min(Iterables.count((Iterable)aliveMembers), (long)this.commonState.getMaxAcceptors())), (Iterable)aliveMembers));
    }

    @Override
    public int getMinimumQuorumSize(List<URI> acceptors) {
        return acceptors.size() / 2 + 1;
    }

    @Override
    public void patchBookedInstances(ClusterMessage.ConfigurationChangeState value) {
        block3: {
            block2: {
                if (value.getJoin() == null) break block2;
                for (InstanceId instanceId : this.bookedInstances.keySet()) {
                    PaxosInstance instance = this.paxosInstances.getPaxosInstance(instanceId);
                    if (instance.getAcceptors() == null) continue;
                    instance.getAcceptors().remove(this.commonState.configuration().getMembers().get(value.getJoin()));
                    this.getLog((Class)ProposerContext.class).debug("For booked instance " + instance + " removed gone member " + this.commonState.configuration().getMembers().get(value.getJoin()) + " added joining member " + value.getJoinUri());
                    if (instance.getAcceptors().contains(value.getJoinUri())) continue;
                    instance.getAcceptors().add(value.getJoinUri());
                }
                break block3;
            }
            if (value.getLeave() == null) break block3;
            for (InstanceId instanceId : this.bookedInstances.keySet()) {
                PaxosInstance instance = this.paxosInstances.getPaxosInstance(instanceId);
                if (instance.getAcceptors() == null) continue;
                this.getLog((Class)ProposerContext.class).debug("For booked instance " + instance + " removed leaving member " + value.getLeave() + " (at URI " + this.commonState.configuration().getMembers().get(value.getLeave()) + ")");
                instance.getAcceptors().remove(this.commonState.configuration().getMembers().get(value.getLeave()));
            }
        }
    }

    public ProposerContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, PaxosInstanceStore paxosInstancesSnapshot, HeartbeatContext heartbeatContext) {
        return new ProposerContextImpl(this.me, commonStateSnapshot, logging, timeouts, new LinkedList<Message>(this.pendingValues), new HashMap<InstanceId, Message>(this.bookedInstances), paxosInstancesSnapshot, heartbeatContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProposerContextImpl that = (ProposerContextImpl)o;
        if (this.bookedInstances != null ? !this.bookedInstances.equals(that.bookedInstances) : that.bookedInstances != null) {
            return false;
        }
        if (this.paxosInstances != null ? !this.paxosInstances.equals(that.paxosInstances) : that.paxosInstances != null) {
            return false;
        }
        return this.pendingValues != null ? this.pendingValues.equals(that.pendingValues) : that.pendingValues == null;
    }

    public int hashCode() {
        int result = this.pendingValues != null ? this.pendingValues.hashCode() : 0;
        result = 31 * result + (this.bookedInstances != null ? this.bookedInstances.hashCode() : 0);
        result = 31 * result + (this.paxosInstances != null ? this.paxosInstances.hashCode() : 0);
        return result;
    }
}

