/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.cluster;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.cluster.ClusterEntryDeniedException;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.statemachine.State;
import org.neo4j.helpers.collection.Iterables;

public enum ClusterState implements State<ClusterContext, ClusterMessage>
{
    start{

        public ClusterState handle(ClusterContext context, Message<ClusterMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case addClusterListener: {
                    context.addClusterListener((ClusterListener)message.getPayload());
                    break;
                }
                case removeClusterListener: {
                    context.removeClusterListener((ClusterListener)message.getPayload());
                    break;
                }
                case create: {
                    String name = (String)message.getPayload();
                    context.getLog(ClusterState.class).info("Creating cluster: " + name);
                    context.created(name);
                    return entered;
                }
                case join: {
                    Object[] args = (Object[])message.getPayload();
                    String name = (String)args[0];
                    Object[] clusterInstanceUris = (URI[])args[1];
                    context.joining(name, Iterables.iterable((Object[])clusterInstanceUris));
                    context.getLog(this.getClass()).info("Trying to join with DISCOVERY header " + context.generateDiscoveryHeader());
                    for (Object potentialClusterInstanceUri : clusterInstanceUris) {
                        outgoing.offer(Message.to(ClusterMessage.configurationRequest, (URI)potentialClusterInstanceUri, new ClusterMessage.ConfigurationRequestState(context.getMyId(), context.boundAt())).setHeader("discovered", context.generateDiscoveryHeader()));
                    }
                    context.setTimeout("discovery", Message.timeout(ClusterMessage.configurationTimeout, message, new ClusterMessage.ConfigurationTimeoutState(1)));
                    return discovery;
                }
            }
            return this;
        }
    }
    ,
    discovery{

        public ClusterState handle(ClusterContext context, Message<ClusterMessage> message, MessageHolder outgoing) throws URISyntaxException {
            List<ClusterMessage.ConfigurationRequestState> discoveredInstances = context.getDiscoveredInstances();
            context.getLog(this.getClass()).info(String.format("Discovered instances are %s", discoveredInstances));
            switch (message.getMessageType()) {
                case configurationResponse: {
                    context.cancelTimeout("discovery");
                    ClusterMessage.ConfigurationResponseState state = (ClusterMessage.ConfigurationResponseState)message.getPayload();
                    context.getLog(ClusterState.class).info("Joining cluster " + state.getClusterName());
                    if (!context.getConfiguration().getName().equals(state.getClusterName())) {
                        context.getLog(ClusterState.class).warn("Joined cluster name is different than the one configured. Expected " + context.getConfiguration().getName() + ", got " + state.getClusterName() + ".");
                    }
                    HashMap<InstanceId, URI> memberList = new HashMap<InstanceId, URI>(state.getMembers());
                    context.discoveredLastReceivedInstanceId(state.getLatestReceivedInstanceId().getId());
                    context.acquiredConfiguration(memberList, state.getRoles(), state.getFailedMembers());
                    if (!memberList.containsKey(context.getMyId()) || !memberList.get(context.getMyId()).equals(context.boundAt())) {
                        context.getLog(ClusterState.class).info(String.format("%s joining:%s, last delivered:%d", context.getMyId().toString(), context.getConfiguration().toString(), state.getLatestReceivedInstanceId().getId()));
                        ClusterMessage.ConfigurationChangeState newState = new ClusterMessage.ConfigurationChangeState();
                        newState.join(context.getMyId(), context.boundAt());
                        InstanceId coordinator = state.getRoles().get("coordinator");
                        if (coordinator != null) {
                            URI coordinatorUri = context.getConfiguration().getUriForId(coordinator);
                            outgoing.offer(Message.to(ProposerMessage.propose, coordinatorUri, newState));
                        } else {
                            outgoing.offer(Message.to(ProposerMessage.propose, new URI(message.getHeader("from")), newState));
                        }
                        context.getLog(ClusterState.class).debug("Setup join timeout for " + message.getHeader("conversation-id"));
                        context.setTimeout("join", Message.timeout(ClusterMessage.joiningTimeout, message, new URI(message.getHeader("from"))));
                        return joining;
                    }
                    context.joined();
                    outgoing.offer(Message.internal(ClusterMessage.joinResponse, context.getConfiguration()));
                    return entered;
                }
                case configurationTimeout: {
                    if (context.hasJoinBeenDenied()) {
                        outgoing.offer(Message.internal(ClusterMessage.joinFailure, new ClusterEntryDeniedException(context.getMyId(), context.getJoinDeniedConfigurationResponseState())));
                        return start;
                    }
                    ClusterMessage.ConfigurationTimeoutState state = (ClusterMessage.ConfigurationTimeoutState)message.getPayload();
                    if (state.getRemainingPings() > 0) {
                        context.getLog(this.getClass()).info(String.format("Trying to join with DISCOVERY header %s", context.generateDiscoveryHeader()));
                        for (URI potentialClusterInstanceUri : context.getJoiningInstances()) {
                            outgoing.offer(Message.to(ClusterMessage.configurationRequest, potentialClusterInstanceUri, new ClusterMessage.ConfigurationRequestState(context.getMyId(), context.boundAt())).setHeader("discovered", context.generateDiscoveryHeader()));
                        }
                        context.setTimeout("join", Message.timeout(ClusterMessage.configurationTimeout, message, new ClusterMessage.ConfigurationTimeoutState(state.getRemainingPings() - 1)));
                    } else if (!discoveredInstances.isEmpty() || Iterables.count(context.getJoiningInstances()) == 1L) {
                        boolean wantToStartCluster;
                        Collections.sort(discoveredInstances);
                        ClusterMessage.ConfigurationRequestState ourRequestState = new ClusterMessage.ConfigurationRequestState(context.getMyId(), context.boundAt());
                        boolean imAlone = Iterables.count(context.getJoiningInstances()) == 1L && discoveredInstances.contains(ourRequestState) && discoveredInstances.size() == 1;
                        boolean haveDiscoveredMajority = (long)discoveredInstances.size() >= Iterables.count(context.getJoiningInstances());
                        boolean bl = wantToStartCluster = !discoveredInstances.isEmpty() && discoveredInstances.get(0).getJoiningId().compareTo(context.getMyId()) >= 0;
                        if (imAlone || haveDiscoveredMajority && wantToStartCluster) {
                            discoveredInstances.clear();
                            outgoing.offer(Message.internal(ClusterMessage.joinFailure, new TimeoutException("Join failed, timeout waiting for configuration")));
                            return start;
                        }
                        discoveredInstances.clear();
                        context.getLog(this.getClass()).info(String.format("Trying to join with DISCOVERY header %s", context.generateDiscoveryHeader()));
                        for (URI potentialClusterInstanceUri : context.getJoiningInstances()) {
                            outgoing.offer(Message.to(ClusterMessage.configurationRequest, potentialClusterInstanceUri, new ClusterMessage.ConfigurationRequestState(context.getMyId(), context.boundAt())).setHeader("discovered", context.generateDiscoveryHeader()));
                        }
                        context.setTimeout("discovery", Message.timeout(ClusterMessage.configurationTimeout, message, new ClusterMessage.ConfigurationTimeoutState(4)));
                    } else {
                        context.setTimeout("join", Message.timeout(ClusterMessage.configurationTimeout, message, new ClusterMessage.ConfigurationTimeoutState(4)));
                    }
                    return this;
                }
                case configurationRequest: {
                    ClusterMessage.ConfigurationRequestState configurationRequested = (ClusterMessage.ConfigurationRequestState)message.getPayload();
                    configurationRequested = new ClusterMessage.ConfigurationRequestState(configurationRequested.getJoiningId(), URI.create(message.getHeader("from")));
                    context.addContactingInstance(configurationRequested, message.getHeader("discovered", ""));
                    context.getLog(this.getClass()).info(String.format("Received configuration request %s and the header was %s", configurationRequested, message.getHeader("discovered", "")));
                    if (discoveredInstances.contains(configurationRequested)) break;
                    for (ClusterMessage.ConfigurationRequestState discoveredInstance : discoveredInstances) {
                        if (!discoveredInstance.getJoiningId().equals(configurationRequested.getJoiningId())) continue;
                        outgoing.offer(Message.internal(ClusterMessage.joinFailure, new IllegalStateException(String.format("Failed to join cluster because I saw two instances with the same ServerId. One is %s. The other is %s", discoveredInstance, configurationRequested))));
                        return start;
                    }
                    if (context.shouldFilterContactingInstances()) {
                        if (context.haveWeContactedInstance(configurationRequested)) {
                            context.getLog(this.getClass()).info(String.format("%s had header %s which contains us. This means we've contacted them and they are in our initial hosts.", configurationRequested, message.getHeader("discovered", "")));
                            discoveredInstances.add(configurationRequested);
                            break;
                        }
                        context.getLog(this.getClass()).warn(String.format("joining instance %s was not in %s, i will not consider it for purposes of cluster creation", configurationRequested.getJoiningUri(), context.getJoiningInstances()));
                        break;
                    }
                    discoveredInstances.add(configurationRequested);
                    break;
                }
                case joinDenied: {
                    context.joinDenied((ClusterMessage.ConfigurationResponseState)message.getPayload());
                    return this;
                }
            }
            return this;
        }
    }
    ,
    joining{

        public ClusterState handle(ClusterContext context, Message<ClusterMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case configurationChanged: {
                    ClusterMessage.ConfigurationChangeState state = (ClusterMessage.ConfigurationChangeState)message.getPayload();
                    if (context.getMyId().equals(state.getJoin())) {
                        context.cancelTimeout("join");
                        context.joined();
                        outgoing.offer(message.copyHeadersTo(Message.internal(ClusterMessage.joinResponse, context.getConfiguration()), new String[0]));
                        return entered;
                    }
                    state.apply(context);
                    return this;
                }
                case joiningTimeout: {
                    context.getLog(ClusterState.class).info("Join timeout for " + message.getHeader("conversation-id"));
                    if (context.hasJoinBeenDenied()) {
                        outgoing.offer(Message.internal(ClusterMessage.joinFailure, new ClusterEntryDeniedException(context.getMyId(), context.getJoinDeniedConfigurationResponseState())));
                        return start;
                    }
                    for (URI potentialClusterInstanceUri : context.getJoiningInstances()) {
                        outgoing.offer(Message.to(ClusterMessage.configurationRequest, potentialClusterInstanceUri, new ClusterMessage.ConfigurationRequestState(context.getMyId(), context.boundAt())).setHeader("discovered", context.generateDiscoveryHeader()));
                    }
                    context.setTimeout("discovery", Message.timeout(ClusterMessage.configurationTimeout, message, new ClusterMessage.ConfigurationTimeoutState(4)));
                    return discovery;
                }
                case joinFailure: {
                    return start;
                }
            }
            return this;
        }
    }
    ,
    entered{

        public ClusterState handle(ClusterContext context, Message<ClusterMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case addClusterListener: {
                    context.addClusterListener((ClusterListener)message.getPayload());
                    break;
                }
                case removeClusterListener: {
                    context.removeClusterListener((ClusterListener)message.getPayload());
                    break;
                }
                case configurationRequest: {
                    boolean somethingIsWrong;
                    ClusterMessage.ConfigurationRequestState request = (ClusterMessage.ConfigurationRequestState)message.getPayload();
                    request = new ClusterMessage.ConfigurationRequestState(request.getJoiningId(), URI.create(message.getHeader("from")));
                    InstanceId joiningId = request.getJoiningId();
                    URI joiningUri = request.getJoiningUri();
                    boolean isInCluster = context.getMembers().containsKey(joiningId);
                    boolean isCurrentlyAlive = context.isCurrentlyAlive(joiningId);
                    boolean messageComesFromSameHost = request.getJoiningId().equals(context.getMyId());
                    boolean otherInstanceJoiningWithSameId = context.isInstanceJoiningFromDifferentUri(joiningId, joiningUri);
                    boolean isFromSameURIAsTheOneWeAlreadyKnow = context.getUriForId(joiningId) != null && context.getUriForId(joiningId).equals(joiningUri);
                    boolean bl = somethingIsWrong = isInCluster && !messageComesFromSameHost && isCurrentlyAlive && !isFromSameURIAsTheOneWeAlreadyKnow || otherInstanceJoiningWithSameId;
                    if (somethingIsWrong) {
                        if (otherInstanceJoiningWithSameId) {
                            context.getLog(ClusterState.class).info(String.format("Denying entry to instance %s because another instance is currently joining with the same id.", joiningId));
                        } else {
                            context.getLog(ClusterState.class).info(String.format("Denying entry to instance %s because that instance is already in the cluster.", joiningId));
                        }
                        outgoing.offer(message.copyHeadersTo(Message.respond(ClusterMessage.joinDenied, message, new ClusterMessage.ConfigurationResponseState(context.getConfiguration().getRoles(), context.getConfiguration().getMembers(), new org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId(context.getLastDeliveredInstanceId()), context.getFailedInstances(), context.getConfiguration().getName())), new String[0]));
                        break;
                    }
                    context.instanceIsJoining(joiningId, joiningUri);
                    outgoing.offer(message.copyHeadersTo(Message.respond(ClusterMessage.configurationResponse, message, new ClusterMessage.ConfigurationResponseState(context.getConfiguration().getRoles(), context.getConfiguration().getMembers(), new org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId(context.getLastDeliveredInstanceId()), context.getFailedInstances(), context.getConfiguration().getName())), new String[0]));
                    break;
                }
                case configurationChanged: {
                    ClusterMessage.ConfigurationChangeState state = (ClusterMessage.ConfigurationChangeState)message.getPayload();
                    state.apply(context);
                    break;
                }
                case leave: {
                    ArrayList<URI> nodeList = new ArrayList<URI>(context.getConfiguration().getMemberURIs());
                    if (nodeList.size() == 1) {
                        context.getLog(ClusterState.class).info(String.format("Shutting down cluster: %s", context.getConfiguration().getName()));
                        context.left();
                        return start;
                    }
                    context.getLog(ClusterState.class).info(String.format("Leaving:%s", nodeList));
                    ClusterMessage.ConfigurationChangeState newState = new ClusterMessage.ConfigurationChangeState();
                    newState.leave(context.getMyId());
                    outgoing.offer(Message.internal(AtomicBroadcastMessage.broadcast, newState));
                    context.setTimeout("leave", Message.timeout(ClusterMessage.leaveTimedout, message));
                    return leaving;
                }
            }
            return this;
        }
    }
    ,
    leaving{

        public ClusterState handle(ClusterContext context, Message<ClusterMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case configurationChanged: {
                    ClusterMessage.ConfigurationChangeState state = (ClusterMessage.ConfigurationChangeState)message.getPayload();
                    if (state.isLeaving(context.getMyId())) {
                        context.cancelTimeout("leave");
                        context.left();
                        return start;
                    }
                    state.apply(context);
                    return leaving;
                }
                case leaveTimedout: {
                    context.getLog(ClusterState.class).warn("Failed to leave. Cluster may consider this instance still a member");
                    context.left();
                    return start;
                }
            }
            return this;
        }
    };

}

