/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.heartbeat;

import java.io.Serializable;
import java.util.Set;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.MessageType;

public enum HeartbeatMessage implements MessageType
{
    addHeartbeatListener,
    removeHeartbeatListener,
    join,
    leave,
    i_am_alive,
    timed_out,
    sendHeartbeat,
    reset_send_heartbeat,
    suspicions;


    public static class SuspicionsState
    implements Serializable {
        private static final long serialVersionUID = 3152836192116904427L;
        private Set<InstanceId> suspicions;

        public SuspicionsState(Set<InstanceId> suspicions) {
            this.suspicions = suspicions;
        }

        public Set<InstanceId> getSuspicions() {
            return this.suspicions;
        }

        public String toString() {
            return "Suspicions:" + this.suspicions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SuspicionsState that = (SuspicionsState)o;
            return this.suspicions != null ? this.suspicions.equals(that.suspicions) : that.suspicions == null;
        }

        public int hashCode() {
            return this.suspicions != null ? this.suspicions.hashCode() : 0;
        }
    }

    public static class IAmAliveState
    implements Serializable {
        private static final long serialVersionUID = 6799806932628197123L;
        private InstanceId server;

        public IAmAliveState(InstanceId server) {
            this.server = server;
        }

        public InstanceId getServer() {
            return this.server;
        }

        public String toString() {
            return "i_am_alive[" + this.server + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IAmAliveState that = (IAmAliveState)o;
            return this.server != null ? this.server.equals(that.server) : that.server == null;
        }

        public int hashCode() {
            return this.server != null ? this.server.hashCode() : 0;
        }
    }
}

