/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ConfigMigrator {
    private final File sourceNeo4jDirectory;
    private final File destinationNeo4jDirectory;
    private static final String MAPPING_TABLE = "/neo4j_config_properties.tsv";
    private final boolean verbose;
    private final List<String> knownDeprecations = Arrays.asList("mapped_memory", "relationship_cache_size");
    private final List<String> defaultJVMXX = Arrays.asList("-XX:+UseG1GC", "-XX:-OmitStackTraceInFastThrow", "-XX:hashCode=5");
    private List<String> defaultSet = Arrays.asList("org.neo4j.server.database.location=data/graph.db", "dbms.security.auth_enabled=true", "dbms.security.allow_outgoing_browser_connections=true", "dbms.browser.remote_content_hostname_whitelist=http://guides.neo4j.com,https://guides.neo4j.com,http://localhost,https://localhost", "dbms.security.tls_certificate_file=conf/ssl/snakeoil.cert", "dbms.security.tls_key_file=conf/ssl/snakeoil.key", "org.neo4j.server.webserver.https.key.location=conf/ssl/snakeoil.key", "org.neo4j.server.webserver.https.cert.location=conf/ssl/snakeoil.cert", "org.neo4j.server.http.log.enabled=false");
    private List<String> enterpriseDefaultSet = Arrays.asList("online_backup_server=127.0.0.1:6362", "online_backup_enabled=true");
    private boolean isEnterprise = false;
    private Map<String, String> renameMap = new LinkedHashMap<String, String>();
    private Map<String, String> removeMap = new LinkedHashMap<String, String>();
    private ArrayList<String> deprecated = new ArrayList();
    private LineMappings wrapperLines = new LineMappings();
    private LineMappings configLines = new LineMappings();
    private HashMap<String, String> cachedValues = new HashMap();
    private static final String LOGDIR_KEY = "dbms.directories.logs";
    private ArrayList<String> multipleLogDirectories = new ArrayList();
    private static final String DEFAULT_HTTP_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_HTTPS_ADDRESS = "localhost";
    private static final String DEFAULT_HTTP_PORT = "7474";
    private static final String DEFAULT_HTTPS_PORT = "7473";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: ConfigMigrator <source neo4j dir> <destination neo4j dir>");
            System.exit(-1);
        }
        try {
            ConfigMigrator migrator = new ConfigMigrator(args[0], args[1], args.length > 2 ? args[2] : MAPPING_TABLE, false);
            migrator.migrate();
        }
        catch (IOException e) {
            System.err.println("Failed to migrate: " + e);
            e.printStackTrace();
        }
    }

    public ConfigMigrator(String srsourceNeo4jDirectorycDir, String destinationNeo4jDirectory) throws IOException {
        this(srsourceNeo4jDirectorycDir, destinationNeo4jDirectory, MAPPING_TABLE, false);
    }

    public ConfigMigrator(String srsourceNeo4jDirectorycDir, String destinationNeo4jDirectory, boolean verbose) throws IOException {
        this(srsourceNeo4jDirectorycDir, destinationNeo4jDirectory, MAPPING_TABLE, verbose);
    }

    public ConfigMigrator(String sourceNeo4jDirectory, String destinationNeo4jDirectory, String mapFilePath, Boolean verbose) throws IOException {
        this.sourceNeo4jDirectory = ConfigMigrator.validateSrcPath(sourceNeo4jDirectory);
        this.destinationNeo4jDirectory = ConfigMigrator.ensurePathExists(destinationNeo4jDirectory);
        this.verbose = verbose;
        if (sourceNeo4jDirectory.contains("enterprise")) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.defaultSet);
            list.addAll(this.enterpriseDefaultSet);
            this.defaultSet = list;
            this.isEnterprise = true;
        }
        this.loadMapFile(mapFilePath);
    }

    public void migrate() throws IOException {
        this.readOriginal(this.sourceNeo4jDirectory);
        this.writeConfigFiles(this.destinationNeo4jDirectory);
    }

    public void writeConfigFiles(File dstDir) throws IOException {
        this.writeConfigFile(dstDir, "neo4j.conf", this.configLines);
        this.writeConfigFile(dstDir, "neo4j-wrapper.conf", this.wrapperLines);
        if (!this.deprecated.isEmpty()) {
            this.warn("\nWARNING: The original config had " + this.deprecated.size() + " deprecated settings that will be excluded:");
            for (String line : this.deprecated) {
                this.warn("\t" + line);
            }
        }
    }

    private void writeConfigFile(File dstDir, String name, LineMappings config) throws IOException {
        File configDir = ConfigMigrator.ensurePathExists(new File(dstDir, "conf").getCanonicalPath());
        File configFile = new File(configDir, name);
        File configBackupFile = new File(configDir, name + ".bak");
        if (!configFile.exists()) {
            this.writeTemplate(configFile);
        }
        try {
            Files.copy(configFile.toPath(), configBackupFile.toPath(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException e) {
            this.println("Backup already exists, not overwriting");
        }
        this.updateConfigFile(configFile, config);
    }

    private String makeLine(List<String> values) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            sb.append(values.get(i));
            if (i >= values.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private void updateConfigFile(File configFile, LineMappings config) throws IOException {
        if (!config.isEmpty()) {
            this.println("\nUpdating " + config.lines.size() + " config settings in " + configFile);
            List<String> lines = Files.readAllLines(configFile.toPath());
            HashSet<String> found = new HashSet<String>();
            HashSet<String> toIgnore = new HashSet<String>();
            BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
            for (String line : lines) {
                String testLine = line.replaceFirst("^#", "");
                ConfRecord record = new ConfRecord(testLine);
                if (record.valid) {
                    for (String key : record.makeKeys()) {
                        if (!config.lines.containsKey(key)) continue;
                        found.add(key);
                        if (toIgnore.contains(key)) {
                            line = null;
                            break;
                        }
                        line = this.makeLine(config.get(key));
                        toIgnore.add(key);
                        break;
                    }
                }
                if (line == null) continue;
                out.write(line + "\n");
            }
            ArrayList<String> missing = new ArrayList<String>();
            for (String key : config.lines.keySet()) {
                if (found.contains(key)) continue;
                missing.add(this.makeLine(config.get(key)));
            }
            if (!missing.isEmpty()) {
                this.warn("\nWARNING: Several options found in the source configuration were not found in the destination.");
                this.warn("These will be written to the end of the neo4j.conf file. Please review and edit:");
                out.write("\n# Config settings ported from previous version\n");
                out.write("# Please review and edit as appropriate\n");
                for (String line : missing) {
                    this.warn("\t" + line);
                    out.write(line + "\n");
                }
            }
            if (!configFile.getName().contains("wrapper") && !this.multipleLogDirectories.isEmpty()) {
                this.warn("\nWARNING: Multiple source configurations specified different log locations.");
                this.warn("These will be written to the end of the neo4j.conf file. Please review and edit:");
                out.write("\n# Multiple possible log directories. Please review and select:\n");
                for (String line : this.multipleLogDirectories) {
                    this.warn("\t" + line);
                    out.write("#" + line + "\n");
                }
            }
            out.close();
        } else {
            this.println("No configuration options found to update - leaving config alone");
        }
    }

    private void writeTemplate(File configFile) {
        String neo4j = "neo4j-" + (this.isEnterprise ? "enterprise" : "community") + "-3.0.0";
        String template = "/template/" + neo4j + "/conf/" + configFile.getName();
        InputStream in = ConfigMigrator.class.getResourceAsStream(template);
        if (in == null) {
            System.err.println("Unable to read template: " + template);
        } else {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
                String data = new Scanner(in).useDelimiter("\\A").next();
                for (String line : data.split("\\n")) {
                    out.write(line + "\n");
                }
                out.close();
            }
            catch (IOException e) {
                System.err.println("Failed to write config file '" + configFile + "': " + e);
            }
        }
    }

    public void readOriginal(File srcFile) throws IOException {
        File configDir = new File(srcFile, "conf");
        File properties = new File(configDir, "neo4j.properties");
        File server = new File(configDir, "neo4j-server.properties");
        File wrapper = new File(configDir, "neo4j-wrapper.conf");
        if (wrapper.exists()) {
            String serverPath = this.readWrapper(wrapper);
            if (serverPath != null) {
                server = new File(this.sourceNeo4jDirectory, serverPath);
            }
        } else {
            this.warn("\nWARNING: No wrapper file found. Attempting to convert without it:");
            this.warn("\t" + wrapper);
        }
        if (server.exists()) {
            String propPath = this.readServer(server);
            if (propPath != null) {
                properties = new File(this.sourceNeo4jDirectory, propPath);
            }
        } else {
            this.warn("\nWARNING: No server config file found. Attempting to convert without it:");
            this.warn("\t" + server);
        }
        if (properties.exists()) {
            this.readProperties(properties);
        } else {
            this.warn("\nWARNING: No properties file found. Attempting to convert without it:");
            this.warn("\t" + properties);
        }
        this.processCachedValues();
        this.resolveMultipleLogDirectories();
    }

    private void resolveMultipleLogDirectories() {
        ArrayList lines;
        if (this.configLines.lines.containsKey(LOGDIR_KEY) && (lines = (ArrayList)this.configLines.lines.get(LOGDIR_KEY)).size() > 1) {
            this.multipleLogDirectories.addAll(lines);
            this.configLines.lines.remove(LOGDIR_KEY);
        }
    }

    private String cacheGetOrElse(String key, String value) {
        return this.cachedValues.containsKey(key) ? this.cachedValues.get(key) : value;
    }

    private void configureConnector(String connector, String addressKey, String defaultAddress, String portKey, String defaultPort, String enabled) {
        String connectorKey = "dbms.connector." + connector;
        if (enabled != null) {
            this.configLines.add(connectorKey + ".enabled", enabled);
        }
        if (this.cachedValues.containsKey(addressKey) || this.cachedValues.containsKey(portKey)) {
            String address = this.cacheGetOrElse(addressKey, defaultAddress);
            String port = this.cacheGetOrElse(portKey, defaultPort);
            this.configLines.add(connectorKey + ".address", address + ":" + port);
        }
    }

    private void processCachedValues() {
        this.configureConnector("http", "httpAddress", DEFAULT_HTTP_ADDRESS, "httpPort", DEFAULT_HTTP_PORT, "true");
        this.configureConnector("https", "httpAddress", DEFAULT_HTTPS_ADDRESS, "httpsPort", DEFAULT_HTTPS_PORT, this.cacheGetOrElse("httpsEnabled", null));
    }

    private void processProperty(ConfRecord record) {
        this.println("\tProcessing: " + record);
        if (this.defaultSet.contains(record.line)) {
            this.println("\t\tIgnoring default value");
            return;
        }
        switch (record.key()) {
            case "org.neo4j.server.webserver.address": {
                this.cachedValues.put("httpAddress", record.value());
                break;
            }
            case "org.neo4j.server.webserver.port": {
                if (record.value().equals(DEFAULT_HTTP_PORT)) break;
                this.cachedValues.put("httpPort", record.value());
                break;
            }
            case "org.neo4j.server.webserver.https.enabled": {
                this.cachedValues.put("httpsEnabled", record.value());
                break;
            }
            case "org.neo4j.server.webserver.https.port": {
                if (record.value().equals(DEFAULT_HTTPS_PORT)) break;
                this.cachedValues.put("httpsPort", record.value());
                break;
            }
            case "dbms.querylog.filename": 
            case "dbms.querylog.path": {
                File logFile = new File(record.value());
                this.configLines.add(LOGDIR_KEY, logFile.getParent());
                break;
            }
            case "org.neo4j.server.database.location": {
                File databaseFile = new File(record.value());
                String dbName = databaseFile.getName();
                String dataDir = databaseFile.getParent();
                if (!dbName.equals("graph.db")) {
                    this.configLines.replace("dbms.active_database", databaseFile.getName());
                }
                if (dataDir.equals("data")) break;
                this.warn("\nWARNING: The previous database location is not compatible with 3.0 standards.");
                this.warn("Please refer to the documentation for advice on migrating:");
                this.warn("\t" + dataDir);
                break;
            }
            case "dbms.security.tls_certificate_file": 
            case "dbms.security.tls_key_file": 
            case "org.neo4j.server.webserver.https.key.location": 
            case "org.neo4j.server.webserver.https.cert.location": {
                File certFile = new File(record.value());
                this.configLines.replace("dbms.directories.certificates", certFile.getParent());
                break;
            }
            default: {
                record.addReplacementTo(this.configLines);
            }
        }
    }

    private void readProperties(File properties) throws IOException {
        this.println("\nReading neo4j properties file: " + properties);
        try (BufferedReader reader = new BufferedReader(new FileReader(properties));){
            ConfRecord record;
            while ((record = this.nextRecord(reader)) != null) {
                this.processProperty(record);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("No properties file: " + e.getMessage());
        }
    }

    private String readServer(File server) throws IOException {
        this.println("\nReading server properties file: " + server);
        String propPath = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(server));){
            ConfRecord record;
            while ((record = this.nextRecord(reader)) != null) {
                if (record.key().equals("org.neo4j.server.db.tuning.properties")) {
                    this.println("\tSetting path to neo4j properties: " + record.line);
                    propPath = record.value();
                    continue;
                }
                this.processProperty(record);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("No server file: " + e.getMessage());
        }
        return propPath;
    }

    private String readWrapper(File wrapper) throws IOException {
        this.println("\nReading wrapper file: " + wrapper);
        String serverPath = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(wrapper));){
            String line;
            ConfRecord record;
            ArrayList<String> unprocessedJWA = new ArrayList<String>();
            ArrayList<String> foundJVMXX = new ArrayList<String>();
            block15: while ((record = this.nextRecord(reader)) != null) {
                switch (record.key()) {
                    case "wrapper.java.additional": {
                        String value;
                        String key;
                        if (record.get(1).equals("-Dorg.neo4j.server.properties")) {
                            this.println("\tSetting path to neo4j server properties: " + record.line);
                            serverPath = record.get(2);
                            break;
                        }
                        if (record.get(1).equals("-Djava.util.logging.config.file") || record.get(1).equals("-Dlog4j.configuration")) {
                            this.println("\tRemoving old logging settings: " + record.line);
                            break;
                        }
                        if (record.value().startsWith("-Xloggc")) {
                            this.configLines.add("dbms.logs.gc.enabled", "true");
                            String[] fields = record.value().split("\\:");
                            if (fields.length <= 1) continue block15;
                            File logFile = new File(fields[1]);
                            this.configLines.add(LOGDIR_KEY, logFile.getParent());
                            break;
                        }
                        if (record.value().startsWith("-XX:+Print")) {
                            this.configLines.append("dbms.logs.gc.options", record.value(), " ");
                            break;
                        }
                        if (record.value().startsWith("-XX:")) {
                            key = "dbms.jvm.additional";
                            value = record.line.replace("wrapper.java.additional=", "");
                            line = key + "=" + value;
                            this.wrapperLines.addLine(line, line);
                            foundJVMXX.add(value);
                            break;
                        }
                        if (record.get(1).startsWith("-Dcom.sun.management.jmxremote")) {
                            key = "dbms.jvm.additional=" + record.get(1);
                            value = record.get(2);
                            this.wrapperLines.addLine(key, key + "=" + value);
                            break;
                        }
                        if (record.get(1).equals("-Dneo4j.ext.udc.source")) {
                            key = "dbms.jvm.additional=-Dunsupported.dbms.udc.source";
                            value = record.get(2);
                            this.wrapperLines.addLine(key, key + "=" + value);
                            break;
                        }
                        unprocessedJWA.add(record.line);
                        break;
                    }
                    case "wrapper.pidfile": {
                        break;
                    }
                    default: {
                        record.addReplacementTo(this.wrapperLines);
                    }
                }
            }
            ArrayList<String> missingJVMXX = new ArrayList<String>();
            for (String value : this.defaultJVMXX) {
                if (foundJVMXX.contains(value)) continue;
                missingJVMXX.add(value);
            }
            if (!missingJVMXX.isEmpty()) {
                this.warn("\nWARNING: Some of the known default JVM -XX options were removed:");
                for (String value : missingJVMXX) {
                    this.warn("\t" + value);
                    String key = "dbms.jvm.additional";
                    line = key + "=" + value;
                    String comment = "# This was removed from older configs and commented out here during migration";
                    this.wrapperLines.addLine(line, comment + "\n#" + line);
                }
            }
            if (!unprocessedJWA.isEmpty()) {
                this.warn("\nWARNING: These wrapper.java.additional lines were unrecognised and will be ignored:");
                for (String line2 : unprocessedJWA) {
                    this.warn("\t" + line2);
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("No wrapper file: " + e.getMessage());
        }
        return serverPath;
    }

    private ConfRecord nextRecord(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            ConfRecord record = new ConfRecord(line);
            if (!record.valid) continue;
            return record;
        }
        return null;
    }

    private void println(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    private void warn(String text) {
        System.out.println(text);
    }

    private static File validateSrcPath(String dir) {
        File file = new File(dir);
        if (file.exists() && file.isDirectory()) {
            File configDir = new File(file, "conf");
            if (configDir.exists() && configDir.isDirectory()) {
                return file;
            }
            throw new IllegalArgumentException("Not a valid Neo4j 2.3 directory '" + file + "': missing conf subdirectory");
        }
        throw new IllegalArgumentException("Not a valid directory: " + file);
    }

    private static File ensurePathExists(String dir) throws IOException {
        File file = new File(dir);
        if (file.exists()) {
            if (file.isDirectory()) {
                return file;
            }
            throw new IllegalArgumentException("Not a directory: " + file);
        }
        if (file.mkdirs()) {
            return file;
        }
        throw new RuntimeException("Failed to make directory: " + file);
    }

    private void loadMapFile(String path) throws FileNotFoundException {
        InputStream in = ConfigMigrator.class.getResourceAsStream(path);
        if (in == null) {
            throw new FileNotFoundException(path);
        }
        String data = new Scanner(in).useDelimiter("\\A").next();
        for (String line : data.split("\\n")) {
            String[] fields = line.trim().split("\\t");
            if (fields.length > 1) {
                String key = fields[2].trim();
                String value = fields[3].trim();
                String action = fields[6].trim();
                if (action.toLowerCase().contains("rename")) {
                    this.renameMap.put(key, value);
                    continue;
                }
                if (!action.toLowerCase().contains("remove")) continue;
                this.removeMap.put(key, value);
                continue;
            }
            System.err.println("Invalid mapping line format: " + line);
        }
        this.debugMap("replacement", this.renameMap);
        this.debugMap("removal", this.removeMap);
    }

    private void debugMap(String name, Map<String, String> map) {
        if (map.size() > 0) {
            this.println("\nImported " + name + " mapping table of " + map.size() + " entries:");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.println("\t" + entry.getKey() + "\t==>\t" + entry.getValue());
            }
        } else {
            System.err.println("Empty " + name + " mapping table");
        }
    }

    private class ConfRecord {
        public final String[] EMPTY_FIELDS = new String[0];
        String line;
        private String[] fields;
        boolean valid;
        boolean isDeprecated;

        public ConfRecord(String line) {
            this.line = line.trim();
            if (line.startsWith("#") || line.isEmpty()) {
                this.valid = false;
                this.fields = this.EMPTY_FIELDS;
            } else {
                this.fields = this.line.split("\\=", -1);
                this.valid = this.fields.length > 1;
            }
            this.isDeprecated = false;
            if (this.valid) {
                for (String text : ConfigMigrator.this.knownDeprecations) {
                    if (!this.key().contains(text)) continue;
                    this.isDeprecated = true;
                }
            }
        }

        public String key() {
            return this.valid ? this.fields[0] : null;
        }

        public List<String> makeKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            for (String field : this.fields) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i <= keys.size(); ++i) {
                    sb.append(this.fields[i]);
                    if (i >= keys.size()) continue;
                    sb.append("=");
                }
                keys.add(sb.toString());
            }
            Collections.reverse(keys);
            return keys;
        }

        public String value() {
            return this.valid ? this.fields[1] : null;
        }

        public String get(int index) {
            return this.valid ? this.fields[index] : null;
        }

        public String toString() {
            return this.line;
        }

        public void addReplacementTo(LineMappings config) {
            if (this.isDeprecated) {
                ConfigMigrator.this.deprecated.add(this.line);
            } else if (ConfigMigrator.this.removeMap.containsKey(this.fields[0])) {
                ConfigMigrator.this.deprecated.add(this.line);
            } else if (ConfigMigrator.this.renameMap.containsKey(this.fields[0])) {
                String key = (String)ConfigMigrator.this.renameMap.get(this.fields[0]);
                config.addLine(key, this.line.replace(this.fields[0], key));
            } else {
                config.addLine(this.key(), this.line);
            }
        }
    }

    class LineMappings {
        private LinkedHashMap<String, ArrayList<String>> lines = new LinkedHashMap();

        LineMappings() {
        }

        public void addLine(String key, String line) {
            this.ensureKey(key);
            ArrayList<String> values = this.lines.get(key);
            if (!values.contains(line)) {
                this.lines.get(key).add(line);
            }
        }

        public void add(String key, String value) {
            this.addLine(key, key + "=" + value);
        }

        public void replace(String key, String value) {
            String line = key + "=" + value;
            if (this.lines.containsKey(key) && !this.lines.get(key).get(0).equals(line)) {
                ConfigMigrator.this.warn("\nWARNING: Overwriting previous config setting for " + key + ":");
                ConfigMigrator.this.warn("\tWas: " + this.lines.get(key).get(0));
                ConfigMigrator.this.warn("\tNow: " + line);
            }
            this.lines.put(key, new ArrayList());
            this.add(key, value);
        }

        public void append(String key, String value, String separator) {
            if (this.lines.containsKey(key)) {
                ArrayList<String> previousValues = this.lines.get(key);
                String previous = previousValues.get(0).toString();
                previousValues.clear();
                previousValues.add(previous + separator + value);
            } else {
                this.add(key, value);
            }
        }

        private void ensureKey(String key) {
            if (!this.lines.containsKey(key)) {
                this.lines.put(key, new ArrayList());
            }
        }

        public List<String> get(String key) {
            this.ensureKey(key);
            return this.lines.get(key);
        }

        public boolean isEmpty() {
            return this.lines.size() == 0;
        }
    }
}

