/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupOutcome;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupProtocolServiceFactory;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class OnlineBackup {
    private final String hostNameOrIp;
    private final int port;
    private boolean forensics;
    private BackupOutcome outcome;
    private long timeoutMillis = BackupClient.BIG_READ_TIMEOUT;
    private OutputStream out = System.out;

    public static OnlineBackup from(String hostNameOrIp, int port) {
        return new OnlineBackup(hostNameOrIp, port);
    }

    public static OnlineBackup from(String hostNameOrIp) {
        return new OnlineBackup(hostNameOrIp, 6362);
    }

    private OnlineBackup(String hostNameOrIp, int port) {
        this.hostNameOrIp = hostNameOrIp;
        this.port = port;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory) {
        return this.backup(new File(targetDirectory));
    }

    @Deprecated
    public OnlineBackup backup(File targetDirectory) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, DatabaseLayout.of((File)targetDirectory), OnlineBackup.getConsistencyCheck(true), config, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, boolean verification) {
        return this.backup(new File(targetDirectory), verification);
    }

    @Deprecated
    public OnlineBackup backup(File targetDirectory, boolean verification) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, DatabaseLayout.of((File)targetDirectory), OnlineBackup.getConsistencyCheck(verification), config, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration) {
        return this.backup(new File(targetDirectory), tuningConfiguration);
    }

    @Deprecated
    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration) {
        this.performBackup(OnlineBackup.defaultConfig(), backupProtocolService -> backupProtocolService.doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, DatabaseLayout.of((File)targetDirectory), OnlineBackup.getConsistencyCheck(true), tuningConfiguration, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration, boolean verification) {
        return this.backup(new File(targetDirectory), tuningConfiguration, verification);
    }

    @Deprecated
    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration, boolean verification) {
        this.performBackup(OnlineBackup.defaultConfig(), backupProtocolService -> backupProtocolService.doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, DatabaseLayout.of((File)targetDirectory), OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics));
        return this;
    }

    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration, boolean verification, String pageCacheSize) {
        Objects.requireNonNull(targetDirectory, "The 'targetDirectory' parameter cannot be null.");
        Objects.requireNonNull(pageCacheSize, "The 'pageCacheSize' parameter cannot be null.");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)pageCacheSize);
        if (tuningConfiguration == null) {
            tuningConfiguration = config;
        } else if (!tuningConfiguration.isConfigured(GraphDatabaseSettings.pagecache_memory)) {
            tuningConfiguration = Config.fromSettings((Map)tuningConfiguration.getRaw()).withSetting(GraphDatabaseSettings.pagecache_memory, pageCacheSize).build();
        }
        Config tuningConfig = tuningConfiguration;
        this.performBackup(config, backupProtocolService -> backupProtocolService.doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, DatabaseLayout.of((File)targetDirectory), OnlineBackup.getConsistencyCheck(verification), tuningConfig, this.timeoutMillis, this.forensics));
        return this;
    }

    public OnlineBackup withTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public OnlineBackup withOutput(OutputStream out) {
        this.out = out;
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doFullBackup(this.hostNameOrIp, this.port, OnlineBackup.getTargetDatabaseLayout(targetDirectory), OnlineBackup.getConsistencyCheck(true), config, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doFullBackup(this.hostNameOrIp, this.port, OnlineBackup.getTargetDatabaseLayout(targetDirectory), OnlineBackup.getConsistencyCheck(verification), config, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification, Config tuningConfiguration) {
        this.performBackup(tuningConfiguration, protocolService -> protocolService.doFullBackup(this.hostNameOrIp, this.port, OnlineBackup.getTargetDatabaseLayout(targetDirectory), OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics));
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doIncrementalBackup(this.hostNameOrIp, this.port, OnlineBackup.getTargetDatabaseLayout(targetDirectory), OnlineBackup.getConsistencyCheck(false), this.timeoutMillis, config));
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory, boolean verification) {
        Config config = OnlineBackup.defaultConfig();
        this.performBackup(config, protocolService -> protocolService.doIncrementalBackup(this.hostNameOrIp, this.port, OnlineBackup.getTargetDatabaseLayout(targetDirectory), OnlineBackup.getConsistencyCheck(verification), this.timeoutMillis, config));
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(GraphDatabaseAPI targetDb) {
        this.performBackup(OnlineBackup.defaultConfig(), protocolService -> BackupProtocolService.doIncrementalBackup(this.hostNameOrIp, this.port, targetDb, this.timeoutMillis));
        return this;
    }

    public long getLastCommittedTx() {
        return this.outcome().getLastCommittedTx();
    }

    public boolean isConsistent() {
        return this.outcome().isConsistent();
    }

    private BackupOutcome outcome() {
        if (this.outcome == null) {
            throw new IllegalStateException("No outcome yet. Please call full or incremental backup first");
        }
        return this.outcome;
    }

    private static Config defaultConfig() {
        return Config.defaults();
    }

    public OnlineBackup gatheringForensics(boolean forensics) {
        this.forensics = forensics;
        return this;
    }

    private static DatabaseLayout getTargetDatabaseLayout(String targetDirectory) {
        return DatabaseLayout.of((File)Paths.get(targetDirectory, new String[0]).toFile());
    }

    private static ConsistencyCheck getConsistencyCheck(boolean verification) {
        return verification ? ConsistencyCheck.FULL : ConsistencyCheck.NONE;
    }

    private void performBackup(Config config, Function<BackupProtocolService, BackupOutcome> backupFunction) {
        try (BackupProtocolService protocolService = BackupProtocolServiceFactory.backupProtocolService(this.out, config);){
            this.outcome = backupFunction.apply(protocolService);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

