/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.net.InetSocketAddress;
import java.net.URI;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.backup.impl.BackupImpl;
import org.neo4j.backup.impl.BackupServer;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreId;

@Deprecated
public class OnlineBackupKernelExtension
extends LifecycleAdapter {
    private Object startBindingListener;
    private Object bindingListener;
    public static final String BACKUP = "backup";
    public static final String INADDR_ANY = "0.0.0.0";
    private final Config config;
    private final GraphDatabaseAPI graphDatabaseAPI;
    private final LogProvider logProvider;
    private final Monitors monitors;
    private BackupServer server;
    private final BackupProvider backupProvider;
    private volatile URI me;

    public OnlineBackupKernelExtension(Config config, GraphDatabaseAPI graphDatabaseAPI, LogProvider logProvider, Monitors monitors, NeoStoreDataSource neoStoreDataSource, FileSystemAbstraction fileSystemAbstraction) {
        this(config, graphDatabaseAPI, () -> {
            DependencyResolver dependencyResolver = graphDatabaseAPI.getDependencyResolver();
            TransactionIdStore transactionIdStore = (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
            StoreCopyServer copier = new StoreCopyServer(neoStoreDataSource, (CheckPointer)dependencyResolver.resolveDependency(CheckPointer.class), fileSystemAbstraction, graphDatabaseAPI.databaseLayout().databaseDirectory(), (StoreCopyServer.Monitor)monitors.newMonitor(StoreCopyServer.Monitor.class, new String[0]));
            LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)dependencyResolver.resolveDependency(LogicalTransactionStore.class);
            LogFileInformation logFileInformation = (LogFileInformation)dependencyResolver.resolveDependency(LogFileInformation.class);
            return new BackupImpl(copier, logicalTransactionStore, transactionIdStore, logFileInformation, () -> ((GraphDatabaseAPI)graphDatabaseAPI).storeId(), logProvider);
        }, monitors, logProvider);
    }

    private OnlineBackupKernelExtension(Config config, GraphDatabaseAPI graphDatabaseAPI, BackupProvider provider, Monitors monitors, LogProvider logProvider) {
        this.config = config;
        this.graphDatabaseAPI = graphDatabaseAPI;
        this.backupProvider = provider;
        this.monitors = monitors;
        this.logProvider = logProvider;
    }

    public synchronized void start() {
        if (((Boolean)this.config.get(OnlineBackupSettings.online_backup_enabled)).booleanValue()) {
            try {
                this.server = new BackupServer(this.backupProvider.newBackup(), (HostnamePort)this.config.get(OnlineBackupSettings.online_backup_server), this.logProvider, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, new String[]{BackupServer.class.getName()}), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, new String[]{BackupServer.class.getName()}));
                this.server.init();
                this.server.start();
                try {
                    this.startBindingListener = new StartBindingListener();
                    ((ClusterMemberEvents)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberEvents.class)).addClusterMemberListener((ClusterMemberListener)this.startBindingListener);
                    this.bindingListener = myUri -> {
                        this.me = myUri;
                    };
                    ((BindingNotifier)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(BindingNotifier.class)).addBindingListener((BindingListener)this.bindingListener);
                }
                catch (NoClassDefFoundError | UnsatisfiedDependencyException throwable) {}
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public synchronized void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop();
            this.server.shutdown();
            this.server = null;
            try {
                ((ClusterMemberEvents)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberEvents.class)).removeClusterMemberListener((ClusterMemberListener)this.startBindingListener);
                ((BindingNotifier)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(BindingNotifier.class)).removeBindingListener((BindingListener)this.bindingListener);
                ClusterMemberAvailability client = this.getClusterMemberAvailability();
                client.memberIsUnavailable(BACKUP);
            }
            catch (NoClassDefFoundError | UnsatisfiedDependencyException throwable) {
                // empty catch block
            }
        }
    }

    private ClusterMemberAvailability getClusterMemberAvailability() {
        return (ClusterMemberAvailability)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberAvailability.class);
    }

    private URI createBackupURI() {
        String hostString = ServerUtil.getHostString((InetSocketAddress)this.server.getSocketAddress());
        String host = hostString.contains(INADDR_ANY) ? this.me.getHost() : hostString;
        int port = this.server.getSocketAddress().getPort();
        return URI.create("backup://" + host + ":" + port);
    }

    private class StartBindingListener
    extends ClusterMemberListener.Adapter {
        private StartBindingListener() {
        }

        public void memberIsAvailable(String role, InstanceId available, URI availableAtUri, StoreId storeId) {
            if (((ClusterClient)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterClient.class)).getServerId().equals((Object)available) && "master".equals(role)) {
                try {
                    URI backupUri = OnlineBackupKernelExtension.this.createBackupURI();
                    ClusterMemberAvailability ha = OnlineBackupKernelExtension.this.getClusterMemberAvailability();
                    ha.memberIsAvailable(OnlineBackupKernelExtension.BACKUP, backupUri, storeId);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }

        public void memberIsUnavailable(String role, InstanceId unavailableId) {
            if (((ClusterClient)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterClient.class)).getServerId().equals((Object)unavailableId) && "master".equals(role)) {
                try {
                    ClusterMemberAvailability ha = OnlineBackupKernelExtension.this.getClusterMemberAvailability();
                    ha.memberIsUnavailable(OnlineBackupKernelExtension.BACKUP);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
    }

    @Deprecated
    public static interface BackupProvider {
        public TheBackupInterface newBackup();
    }
}

