/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.FileMoveProvider;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;

class BackupCopyService {
    private static final int MAX_OLD_BACKUPS = 1000;
    private final FileSystemAbstraction fs;
    private final FileMoveProvider fileMoveProvider;

    BackupCopyService(FileSystemAbstraction fs, FileMoveProvider fileMoveProvider) {
        this.fs = fs;
        this.fileMoveProvider = fileMoveProvider;
    }

    void moveBackupLocation(Path oldLocation, Path newLocation) throws IOException {
        try {
            File source = oldLocation.toFile();
            File target = newLocation.toFile();
            Iterator moves = this.fileMoveProvider.traverseForMoving(source).iterator();
            while (moves.hasNext()) {
                ((FileMoveAction)moves.next()).move(target, new CopyOption[0]);
            }
            oldLocation.toFile().delete();
        }
        catch (IOException e) {
            throw new IOException("Failed to rename backup directory from " + oldLocation + " to " + newLocation, e);
        }
    }

    void clearIdFiles(Path backupLocation) throws IOException {
        File[] files;
        IOException exception = null;
        File targetDirectory = backupLocation.toFile();
        for (File file : files = this.fs.listFiles(targetDirectory)) {
            if (this.fs.isDirectory(file) || !file.getName().endsWith(".id")) continue;
            try {
                long highId = IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fs, (File)file);
                this.fs.deleteFile(file);
                IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)file, (long)highId, (boolean)true);
            }
            catch (IOException e) {
                exception = (IOException)Exceptions.chain(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    boolean backupExists(DatabaseLayout databaseLayout) {
        return databaseLayout.metadataStore().exists();
    }

    Path findNewBackupLocationForBrokenExisting(Path existingBackup) {
        return this.findAnAvailableBackupLocation(existingBackup, "%s.err.%d");
    }

    Path findAnAvailableLocationForNewFullBackup(Path desiredBackupLocation) {
        return this.findAnAvailableBackupLocation(desiredBackupLocation, "%s.temp.%d");
    }

    private Path findAnAvailableBackupLocation(Path file, String pattern) {
        if (this.backupExists(DatabaseLayout.of((File)file.toFile()))) {
            AtomicLong counter = new AtomicLong(0L);
            Consumer<Path> countNumberOfFilesProcessedForPotentialErrorMessage = generatedBackupFile -> counter.getAndIncrement();
            return BackupCopyService.availableAlternativeNames(file, pattern).peek(countNumberOfFilesProcessedForPotentialErrorMessage).filter(f -> !this.backupExists(DatabaseLayout.of((File)f.toFile()))).findFirst().orElseThrow(BackupCopyService.noFreeBackupLocation(file, counter));
        }
        return file;
    }

    private static Supplier<RuntimeException> noFreeBackupLocation(Path file, AtomicLong counter) {
        return () -> new RuntimeException(String.format("Unable to find a free backup location for the provided %s. %d possible locations were already taken.", file, counter.get()));
    }

    private static Stream<Path> availableAlternativeNames(Path originalBackupDirectory, String pattern) {
        return IntStream.range(0, 1000).mapToObj(iteration -> BackupCopyService.alteredBackupDirectoryName(pattern, originalBackupDirectory, iteration));
    }

    private static Path alteredBackupDirectoryName(String pattern, Path directory, int iteration) {
        Path directoryName = directory.getName(directory.getNameCount() - 1);
        return directory.resolveSibling(String.format(pattern, directoryName, iteration));
    }
}

