/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import java.time.Clock;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.helpers.Format;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;

class BackupOutputMonitor
implements StoreCopyClientMonitor {
    private final Log log;
    private final Clock clock;
    private long startTime;
    private long partStartTime;

    BackupOutputMonitor(OutsideWorld outsideWorld) {
        this(outsideWorld, Clock.systemUTC());
    }

    BackupOutputMonitor(OutsideWorld outsideWorld, Clock clock) {
        FormattedLogProvider stdOutLogProvider = FormattedLogProvider.toOutputStream((OutputStream)outsideWorld.outStream());
        this.log = stdOutLogProvider.getLog(BackupOutputMonitor.class);
        this.clock = clock;
    }

    public void start() {
        this.startTime = this.clock.millis();
    }

    public void startReceivingStoreFiles() {
        this.log.info("Start receiving store files");
        this.notePartStartTime();
    }

    public void finishReceivingStoreFiles() {
        this.log.info("Finish receiving store files, took %s", new Object[]{this.durationSincePartStartTime()});
    }

    public void startReceivingStoreFile(String file) {
        this.log.info("Start receiving store file %s", new Object[]{file});
    }

    public void finishReceivingStoreFile(String file) {
        this.log.info("Finish receiving store file %s", new Object[]{file});
    }

    public void startReceivingTransactions(long startTxId) {
        this.log.info("Start receiving transactions from %d", new Object[]{startTxId});
        this.notePartStartTime();
    }

    public void finishReceivingTransactions(long endTxId) {
        this.log.info("Finish receiving transactions at %d, took %s", new Object[]{endTxId, this.durationSincePartStartTime()});
    }

    public void startRecoveringStore() {
        this.log.info("Start recovering store");
        this.notePartStartTime();
    }

    public void finishRecoveringStore() {
        this.log.info("Finish recovering store, took %s", new Object[]{this.durationSincePartStartTime()});
    }

    public void startReceivingIndexSnapshots() {
        this.log.info("Start receiving index snapshots");
        this.notePartStartTime();
    }

    public void startReceivingIndexSnapshot(long indexId) {
        this.log.info("Start receiving index snapshot id %d", new Object[]{indexId});
    }

    public void finishReceivingIndexSnapshot(long indexId) {
        this.log.info("Finished receiving index snapshot id %d", new Object[]{indexId});
    }

    public void finishReceivingIndexSnapshots() {
        this.log.info("Finished receiving index snapshots, took %s", new Object[]{this.durationSincePartStartTime()});
    }

    public void finish() {
        this.log.info("Finished, took %s", new Object[]{this.durationSinceStartTime(this.startTime)});
    }

    private void notePartStartTime() {
        this.partStartTime = this.clock.millis();
    }

    private String durationSincePartStartTime() {
        return this.durationSinceStartTime(this.partStartTime);
    }

    private String durationSinceStartTime(long startTime) {
        long time = this.clock.millis() - startTime;
        return Format.duration((long)time);
    }
}

