/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupOutcome;
import org.neo4j.backup.impl.BackupPageCacheContainer;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.backup.impl.ConsistencyCheckFailedException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.StoreId;

public class BackupProtocolService
implements AutoCloseable {
    static final String TOO_OLD_BACKUP = "It's been too long since this backup was last updated, and it has fallen too far behind the database transaction stream for incremental backup to be possible. You need to perform a full backup at this point. You can modify this time interval by setting the '" + GraphDatabaseSettings.keep_logical_logs.name() + "' configuration on the database to a higher value.";
    static final String DIFFERENT_STORE_MESSAGE = "Target directory contains full backup of a logically different store.";
    private final Supplier<FileSystemAbstraction> fileSystemSupplier;
    private final LogProvider logProvider;
    private final Log log;
    private final OutputStream logDestination;
    private final Monitors monitors;
    private final BackupPageCacheContainer pageCacheContianer;

    BackupProtocolService(Supplier<FileSystemAbstraction> fileSystemSupplier, LogProvider logProvider, OutputStream logDestination, Monitors monitors, BackupPageCacheContainer pageCacheContainer) {
        this.fileSystemSupplier = fileSystemSupplier;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.logDestination = logDestination;
        this.monitors = monitors;
        this.pageCacheContianer = pageCacheContainer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupOutcome doFullBackup(String sourceHostNameOrIp, int sourcePort, DatabaseLayout targetLayout, ConsistencyCheck consistencyCheck, Config tuningConfiguration, long timeout, boolean forensics) {
        try (FileSystemAbstraction fileSystem = this.fileSystemSupplier.get();){
            BackupOutcome backupOutcome = this.fullBackup(fileSystem, sourceHostNameOrIp, sourcePort, targetLayout, consistencyCheck, tuningConfiguration, timeout, forensics);
            return backupOutcome;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BackupOutcome fullBackup(FileSystemAbstraction fileSystem, String sourceHostNameOrIp, int sourcePort, DatabaseLayout targetLayout, ConsistencyCheck consistencyCheck, Config tuningConfiguration, long timeout, boolean forensics) {
        try {
            if (!BackupProtocolService.directoryIsEmpty(targetLayout)) {
                throw new RuntimeException("Can only perform a full backup into an empty directory but " + targetLayout + " is not empty");
            }
            long timestamp = System.currentTimeMillis();
            long lastCommittedTx = -1L;
            StoreCopyClient storeCopier = new StoreCopyClient(targetLayout, tuningConfiguration, BackupProtocolService.loadKernelExtensions(), this.logProvider, fileSystem, this.pageCacheContianer.getPageCache(), (StoreCopyClientMonitor)this.monitors.newMonitor(StoreCopyClientMonitor.class, new String[]{this.getClass().getName()}), forensics);
            FullBackupStoreCopyRequester storeCopyRequester = new FullBackupStoreCopyRequester(sourceHostNameOrIp, sourcePort, timeout, forensics, this.monitors);
            storeCopier.copyStore((StoreCopyClient.StoreCopyRequester)storeCopyRequester, CancellationRequest.NEVER_CANCELLED, MoveAfterCopy.moveReplaceExisting());
            tuningConfiguration.augment(GraphDatabaseSettings.logs_directory, targetLayout.databaseDirectory().toPath().toRealPath(new LinkOption[0]).toString());
            File debugLogFile = (File)tuningConfiguration.get(GraphDatabaseSettings.store_internal_log_path);
            BackupProtocolService.bumpDebugDotLogFileVersion(debugLogFile, timestamp);
            boolean consistent = this.checkDbConsistency(fileSystem, targetLayout, consistencyCheck, tuningConfiguration, this.pageCacheContianer.getPageCache());
            BackupProtocolService.clearIdFiles(fileSystem, targetLayout);
            return new BackupOutcome(lastCommittedTx, consistent);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, DatabaseLayout databaseLayout, ConsistencyCheck consistencyCheck, long timeout, Config config) throws IncrementalBackupNotPossibleException {
        try (FileSystemAbstraction fileSystem = this.fileSystemSupplier.get();){
            BackupOutcome backupOutcome = this.incrementalBackup(fileSystem, sourceHostNameOrIp, sourcePort, databaseLayout, consistencyCheck, timeout, config);
            return backupOutcome;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupOutcome incrementalBackup(FileSystemAbstraction fileSystem, String sourceHostNameOrIp, int sourcePort, DatabaseLayout targetLayout, ConsistencyCheck consistencyCheck, long timeout, Config config) {
        try {
            long lastCommittedTx;
            if (!BackupProtocolService.directoryContainsDb(targetLayout)) {
                throw new RuntimeException(targetLayout + " doesn't contain a database");
            }
            Map<String, String> temporaryDbConfig = BackupProtocolService.getTemporaryDbConfig();
            config.augment(temporaryDbConfig);
            Map configParams = config.getRaw();
            GraphDatabaseAPI targetDb = BackupProtocolService.startTemporaryDb(targetLayout.databaseDirectory(), this.pageCacheContianer.getPageCache(), configParams);
            long backupStartTime = System.currentTimeMillis();
            try {
                lastCommittedTx = BackupProtocolService.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, timeout, BackupProtocolService.slaveContextOf(targetDb));
            }
            finally {
                targetDb.shutdown();
                File lockFile = targetLayout.getStoreLayout().storeLockFile();
                if (lockFile.exists()) {
                    FileUtils.deleteFile((File)lockFile);
                }
            }
            config.augment(GraphDatabaseSettings.logs_directory, targetLayout.databaseDirectory().getCanonicalPath());
            File debugLogFile = (File)config.get(GraphDatabaseSettings.store_internal_log_path);
            BackupProtocolService.bumpDebugDotLogFileVersion(debugLogFile, backupStartTime);
            boolean consistent = this.checkDbConsistency(fileSystem, targetLayout, consistencyCheck, config, this.pageCacheContianer.getPageCache());
            BackupProtocolService.clearIdFiles(fileSystem, targetLayout);
            return new BackupOutcome(lastCommittedTx, consistent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkDbConsistency(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, ConsistencyCheck consistencyCheck, Config tuningConfiguration, PageCache pageCache) {
        boolean consistent = false;
        try {
            consistent = consistencyCheck.runFull(databaseLayout, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)this.logDestination), this.logProvider, fileSystem, pageCache, false, new ConsistencyFlags(tuningConfiguration));
        }
        catch (ConsistencyCheckFailedException e) {
            this.log.error("Consistency check incomplete", (Throwable)e);
        }
        return consistent;
    }

    private static Map<String, String> getTemporaryDbConfig() {
        HashMap<String, String> tempDbConfig = new HashMap<String, String>();
        tempDbConfig.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        tempDbConfig.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
        tempDbConfig.put(GraphDatabaseSettings.pagecache_warmup_enabled.name(), "false");
        return tempDbConfig;
    }

    /*
     * Exception decompiling
     */
    public BackupOutcome doIncrementalBackupOrFallbackToFull(String sourceHostNameOrIp, int sourcePort, DatabaseLayout targetLayout, ConsistencyCheck consistencyCheck, Config config, long timeout, boolean forensics) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK], 18[CATCHBLOCK], 10[TRYBLOCK], 3[TRYBLOCK], 6[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout) throws IncrementalBackupNotPossibleException {
        long lastCommittedTransaction = BackupProtocolService.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, timeout, BackupProtocolService.slaveContextOf(targetDb));
        return new BackupOutcome(lastCommittedTransaction, true);
    }

    private static RequestContext slaveContextOf(GraphDatabaseAPI graphDb) {
        TransactionIdStore transactionIdStore = (TransactionIdStore)graphDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return RequestContext.anonymous((long)transactionIdStore.getLastCommittedTransactionId());
    }

    private static boolean directoryContainsDb(DatabaseLayout databaseLayout) {
        return Files.isRegularFile(databaseLayout.metadataStore().toPath(), new LinkOption[0]);
    }

    private static boolean directoryIsEmpty(DatabaseLayout databaseLayout) throws IOException {
        Path path = databaseLayout.databaseDirectory().toPath();
        return Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && FileUtils.countFilesInDirectoryPath((Path)path) == 0L;
    }

    static GraphDatabaseAPI startTemporaryDb(File storeDir, PageCache pageCache, Map<String, String> config) {
        ExternallyManagedPageCache.GraphDatabaseFactoryWithPageCacheFactory factory = ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache((PageCache)pageCache);
        return (GraphDatabaseAPI)factory.newEmbeddedDatabaseBuilder(storeDir).setConfig(config).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    private static long incrementalWithContext(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout, RequestContext context) throws IncrementalBackupNotPossibleException {
        DependencyResolver resolver = targetDb.getDependencyResolver();
        ProgressTxHandler handler = new ProgressTxHandler();
        TransactionCommittingResponseUnpacker unpacker = new TransactionCommittingResponseUnpacker(resolver, 100, 0L);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        LogProvider logProvider = ((LogService)resolver.resolveDependency(LogService.class)).getInternalLogProvider();
        BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, null, logProvider, targetDb.storeId(), timeout, (ResponseUnpacker)unpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, new String[]{BackupClient.class.getName()}), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, new String[]{BackupClient.class.getName()}), (LogEntryReader<ReadableClosablePositionAwareChannel>)new VersionAwareLogEntryReader());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{unpacker, client});
             Response<Void> response = client.incrementalBackup(context);){
            unpacker.unpackResponse(response, (ResponseUnpacker.TxHandler)handler);
        }
        catch (MismatchingStoreIdException e) {
            throw new RuntimeException(DIFFERENT_STORE_MESSAGE, e);
        }
        catch (IOException | RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof MissingLogDataException) {
                throw new IncrementalBackupNotPossibleException(TOO_OLD_BACKUP, e.getCause());
            }
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            throw new RuntimeException("Failed to perform incremental backup.", e);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unexpected error", throwable);
        }
        return handler.getLastSeenTransactionId();
    }

    private static void bumpDebugDotLogFileVersion(File debugLogFile, long toTimestamp) {
        if (!debugLogFile.exists()) {
            return;
        }
        File to = new File(debugLogFile.getParentFile(), debugLogFile.getName() + "." + toTimestamp);
        debugLogFile.renameTo(to);
    }

    private static List<KernelExtensionFactory<?>> loadKernelExtensions() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return kernelExtensions;
    }

    private static void clearIdFiles(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) throws IOException {
        for (File file : fileSystem.listFiles(databaseLayout.databaseDirectory())) {
            if (fileSystem.isDirectory(file) || !file.getName().endsWith(".id")) continue;
            long highId = IdGeneratorImpl.readHighId((FileSystemAbstraction)fileSystem, (File)file);
            fileSystem.deleteFile(file);
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)fileSystem, (File)file, (long)highId, (boolean)true);
        }
    }

    @Override
    public void close() throws Exception {
        this.pageCacheContianer.close();
    }

    private static class FullBackupStoreCopyRequester
    implements StoreCopyClient.StoreCopyRequester {
        private final String sourceHostNameOrIp;
        private final int sourcePort;
        private final long timeout;
        private final boolean forensics;
        private final Monitors monitors;
        private BackupClient client;

        private FullBackupStoreCopyRequester(String sourceHostNameOrIp, int sourcePort, long timeout, boolean forensics, Monitors monitors) {
            this.sourceHostNameOrIp = sourceHostNameOrIp;
            this.sourcePort = sourcePort;
            this.timeout = timeout;
            this.forensics = forensics;
            this.monitors = monitors;
        }

        public Response<?> copyStore(StoreWriter writer) {
            this.client = new BackupClient(this.sourceHostNameOrIp, this.sourcePort, null, (LogProvider)NullLogProvider.getInstance(), StoreId.DEFAULT, this.timeout, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, new String[0]), (LogEntryReader<ReadableClosablePositionAwareChannel>)new VersionAwareLogEntryReader());
            this.client.start();
            return this.client.fullBackup(writer, this.forensics);
        }

        public void done() {
            this.client.stop();
        }
    }

    private static class ProgressTxHandler
    implements ResponseUnpacker.TxHandler {
        private long lastSeenTransactionId;

        private ProgressTxHandler() {
        }

        public void accept(long transactionId) {
            this.lastSeenTransactionId = transactionId;
        }

        long getLastSeenTransactionId() {
            return this.lastSeenTransactionId;
        }
    }
}

