/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.backup.impl.BackupPageCacheContainer;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public final class BackupProtocolServiceFactory {
    private BackupProtocolServiceFactory() {
    }

    public static BackupProtocolService backupProtocolService(OutputStream logDestination, Config config) {
        JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (Config)config, (JobScheduler)scheduler);
        BackupPageCacheContainer pageCacheContainer = BackupPageCacheContainer.of(pageCache, scheduler);
        return BackupProtocolServiceFactory.backupProtocolService(() -> fs, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)logDestination), logDestination, new Monitors(), pageCacheContainer);
    }

    public static BackupProtocolService backupProtocolService(Supplier<FileSystemAbstraction> fileSystemSupplier, LogProvider logProvider, OutputStream logDestination, Monitors monitors, PageCache pageCache) {
        return BackupProtocolServiceFactory.backupProtocolService(fileSystemSupplier, logProvider, logDestination, monitors, BackupPageCacheContainer.of(pageCache));
    }

    private static BackupProtocolService backupProtocolService(Supplier<FileSystemAbstraction> fileSystemSupplier, LogProvider logProvider, OutputStream logDestination, Monitors monitors, BackupPageCacheContainer pageCacheContainer) {
        Objects.requireNonNull(fileSystemSupplier);
        Objects.requireNonNull(logProvider);
        Objects.requireNonNull(logDestination);
        Objects.requireNonNull(monitors);
        Objects.requireNonNull(pageCacheContainer);
        return new BackupProtocolService(fileSystemSupplier, logProvider, logDestination, monitors, pageCacheContainer);
    }
}

