/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class BackupRecoveryService {
    BackupRecoveryService() {
    }

    void recoverWithDatabase(Path databaseDirectory, PageCache pageCache, Config config) {
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databaseDirectory.toFile());
        Map configParams = config.getRaw();
        configParams.put(GraphDatabaseSettings.logical_logs_location.name(), databaseDirectory.toString());
        configParams.put(GraphDatabaseSettings.active_database.name(), databaseLayout.getDatabaseName());
        configParams.put(GraphDatabaseSettings.pagecache_warmup_enabled.name(), "false");
        GraphDatabaseAPI targetDb = BackupProtocolService.startTemporaryDb(databaseLayout.databaseDirectory(), pageCache, configParams);
        targetDb.shutdown();
        File lockFile = databaseLayout.getStoreLayout().storeLockFile();
        if (lockFile.exists()) {
            FileUtils.deleteFile((File)lockFile);
        }
    }
}

