/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.backup.impl.BackupStrategyOutcome;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

class BackupStrategyCoordinator {
    private static final int STATUS_CC_ERROR = 2;
    private static final int STATUS_CC_INCONSISTENT = 3;
    private ConsistencyCheckService consistencyCheckService;
    private final OutsideWorld outsideWorld;
    private final LogProvider logProvider;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final List<BackupStrategyWrapper> strategies;

    BackupStrategyCoordinator(ConsistencyCheckService consistencyCheckService, OutsideWorld outsideWorld, LogProvider logProvider, ProgressMonitorFactory progressMonitorFactory, List<BackupStrategyWrapper> strategies) {
        this.consistencyCheckService = consistencyCheckService;
        this.outsideWorld = outsideWorld;
        this.logProvider = logProvider;
        this.progressMonitorFactory = progressMonitorFactory;
        this.strategies = strategies;
    }

    public void performBackup(OnlineBackupContext onlineBackupContext) throws CommandFailed {
        BackupStrategyWrapper backupStrategy;
        OnlineBackupRequiredArguments requiredArgs = onlineBackupContext.getRequiredArguments();
        Path destination = onlineBackupContext.getResolvedLocationFromName();
        ConsistencyFlags consistencyFlags = onlineBackupContext.getConsistencyFlags();
        Fallible<BackupStrategyOutcome> throwableWithState = null;
        ArrayList causesOfFailure = new ArrayList();
        Iterator<BackupStrategyWrapper> iterator = this.strategies.iterator();
        while (iterator.hasNext() && (throwableWithState = (backupStrategy = iterator.next()).doBackup(onlineBackupContext)).getState() != BackupStrategyOutcome.SUCCESS) {
            if (throwableWithState.getState() == BackupStrategyOutcome.CORRECT_STRATEGY_FAILED) {
                throw BackupStrategyCoordinator.commandFailedWithCause(throwableWithState).get();
            }
            throwableWithState.getCause().ifPresent(causesOfFailure::add);
        }
        if (throwableWithState == null || !BackupStrategyOutcome.SUCCESS.equals(throwableWithState.getState())) {
            CommandFailed commandFailed = new CommandFailed("Failed to run a backup using the available strategies.");
            causesOfFailure.forEach(arg_0 -> commandFailed.addSuppressed(arg_0));
            throw commandFailed;
        }
        if (requiredArgs.isDoConsistencyCheck()) {
            this.performConsistencyCheck(onlineBackupContext.getConfig(), requiredArgs, consistencyFlags, DatabaseLayout.of((File)destination.toFile()));
        }
    }

    private static Supplier<CommandFailed> commandFailedWithCause(Fallible<BackupStrategyOutcome> cause) {
        if (cause.getCause().isPresent()) {
            return () -> new CommandFailed("Execution of backup failed", cause.getCause().get());
        }
        return () -> new CommandFailed("Execution of backup failed");
    }

    private void performConsistencyCheck(Config config, OnlineBackupRequiredArguments requiredArgs, ConsistencyFlags consistencyFlags, DatabaseLayout layout) throws CommandFailed {
        try {
            boolean verbose = false;
            File reportDir = requiredArgs.getReportDir().toFile();
            ConsistencyCheckService.Result ccResult = this.consistencyCheckService.runFullConsistencyCheck(layout, config, this.progressMonitorFactory, this.logProvider, this.outsideWorld.fileSystem(), verbose, reportDir, consistencyFlags);
            if (!ccResult.isSuccessful()) {
                throw new CommandFailed(String.format("Inconsistencies found. See '%s' for details.", ccResult.reportFile()), 3);
            }
        }
        catch (Throwable e) {
            if (e instanceof CommandFailed) {
                throw (CommandFailed)e;
            }
            throw new CommandFailed("Failed to do consistency check on backup: " + e.getMessage(), e, 2);
        }
    }
}

