/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import java.util.List;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.backup.impl.BackupCopyService;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupModule;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupRecoveryService;
import org.neo4j.backup.impl.BackupStrategy;
import org.neo4j.backup.impl.BackupStrategyCoordinator;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.CausalClusteringBackupStrategy;
import org.neo4j.backup.impl.HaBackupStrategy;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.StrategyResolverService;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.com.storecopy.FileMoveProvider;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

class BackupStrategyCoordinatorFactory {
    private final LogProvider logProvider;
    private final ConsistencyCheckService consistencyCheckService;
    private final AddressResolver addressResolver;
    private final OutsideWorld outsideWorld;

    BackupStrategyCoordinatorFactory(BackupModule backupModule) {
        this.logProvider = backupModule.getLogProvider();
        this.outsideWorld = backupModule.getOutsideWorld();
        this.consistencyCheckService = new ConsistencyCheckService();
        this.addressResolver = new AddressResolver();
    }

    BackupStrategyCoordinator backupStrategyCoordinator(OnlineBackupContext onlineBackupContext, BackupProtocolService backupProtocolService, BackupDelegator backupDelegator, PageCache pageCache) {
        FileSystemAbstraction fs = this.outsideWorld.fileSystem();
        BackupCopyService copyService = new BackupCopyService(fs, new FileMoveProvider(fs));
        ProgressMonitorFactory progressMonitorFactory = ProgressMonitorFactory.textual((OutputStream)this.outsideWorld.errorStream());
        BackupRecoveryService recoveryService = new BackupRecoveryService();
        long timeout = onlineBackupContext.getRequiredArguments().getTimeout();
        Config config = onlineBackupContext.getConfig();
        StoreFiles storeFiles = new StoreFiles(fs, pageCache);
        CausalClusteringBackupStrategy ccStrategy = new CausalClusteringBackupStrategy(backupDelegator, this.addressResolver, this.logProvider, storeFiles);
        HaBackupStrategy haStrategy = new HaBackupStrategy(backupProtocolService, this.addressResolver, this.logProvider, timeout);
        BackupStrategyWrapper ccStrategyWrapper = this.wrap(ccStrategy, copyService, pageCache, config, recoveryService);
        BackupStrategyWrapper haStrategyWrapper = this.wrap(haStrategy, copyService, pageCache, config, recoveryService);
        StrategyResolverService strategyResolverService = new StrategyResolverService(haStrategyWrapper, ccStrategyWrapper);
        List<BackupStrategyWrapper> strategies = strategyResolverService.getStrategies(onlineBackupContext.getRequiredArguments().getSelectedBackupProtocol());
        return new BackupStrategyCoordinator(this.consistencyCheckService, this.outsideWorld, this.logProvider, progressMonitorFactory, strategies);
    }

    private BackupStrategyWrapper wrap(BackupStrategy strategy, BackupCopyService copyService, PageCache pageCache, Config config, BackupRecoveryService recoveryService) {
        return new BackupStrategyWrapper(strategy, copyService, pageCache, config, recoveryService, this.logProvider);
    }
}

