/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.BackupStrategy;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class CausalClusteringBackupStrategy
extends LifecycleAdapter
implements BackupStrategy {
    private final BackupDelegator backupDelegator;
    private final AddressResolver addressResolver;
    private final Log log;
    private final StoreFiles storeFiles;

    CausalClusteringBackupStrategy(BackupDelegator backupDelegator, AddressResolver addressResolver, LogProvider logProvider, StoreFiles storeFiles) {
        this.backupDelegator = backupDelegator;
        this.addressResolver = addressResolver;
        this.log = logProvider.getLog(CausalClusteringBackupStrategy.class);
        this.storeFiles = storeFiles;
    }

    @Override
    public Fallible<BackupStageOutcome> performFullBackup(DatabaseLayout targetDatabaseLayout, Config config, OptionalHostnamePort userProvidedAddress) {
        StoreId storeId;
        AdvertisedSocketAddress fromAddress = this.addressResolver.resolveCorrectCCAddress(config, userProvidedAddress);
        this.log.info("Resolved address for catchup protocol is " + fromAddress);
        try {
            storeId = this.backupDelegator.fetchStoreId(fromAddress);
            this.log.info("Remote store id is " + storeId);
        }
        catch (StoreIdDownloadFailedException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.WRONG_PROTOCOL, e);
        }
        Optional<StoreId> expectedStoreId = this.readLocalStoreId(targetDatabaseLayout);
        if (expectedStoreId.isPresent()) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, new StoreIdDownloadFailedException(String.format("Cannot perform a full backup onto preexisting backup. Remote store id was %s but local is %s", storeId, expectedStoreId)));
        }
        try {
            this.backupDelegator.copy(fromAddress, storeId, targetDatabaseLayout);
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.SUCCESS, null);
        }
        catch (StoreCopyFailedException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, e);
        }
    }

    @Override
    public Fallible<BackupStageOutcome> performIncrementalBackup(DatabaseLayout databaseLayout, Config config, OptionalHostnamePort userProvidedAddress) {
        StoreId storeId;
        AdvertisedSocketAddress fromAddress = this.addressResolver.resolveCorrectCCAddress(config, userProvidedAddress);
        this.log.info("Resolved address for catchup protocol is " + fromAddress);
        try {
            storeId = this.backupDelegator.fetchStoreId(fromAddress);
            this.log.info("Remote store id is " + storeId);
        }
        catch (StoreIdDownloadFailedException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.WRONG_PROTOCOL, e);
        }
        Optional<StoreId> expectedStoreId = this.readLocalStoreId(databaseLayout);
        if (!expectedStoreId.isPresent() || !expectedStoreId.get().equals((Object)storeId)) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, new StoreIdDownloadFailedException(String.format("Remote store id was %s but local is %s", storeId, expectedStoreId)));
        }
        return this.catchup(fromAddress, storeId, databaseLayout);
    }

    public void start() throws Throwable {
        super.start();
        this.backupDelegator.start();
    }

    public void stop() throws Throwable {
        this.backupDelegator.stop();
        super.stop();
    }

    private Optional<StoreId> readLocalStoreId(DatabaseLayout databaseLayout) {
        try {
            return Optional.of(this.storeFiles.readStoreId(databaseLayout));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Fallible<BackupStageOutcome> catchup(AdvertisedSocketAddress fromAddress, StoreId storeId, DatabaseLayout databaseLayout) {
        CatchupResult catchupResult;
        try {
            catchupResult = this.backupDelegator.tryCatchingUp(fromAddress, storeId, databaseLayout);
        }
        catch (StoreCopyFailedException e) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, e);
        }
        if (catchupResult == CatchupResult.SUCCESS_END_OF_STREAM) {
            return new Fallible<BackupStageOutcome>(BackupStageOutcome.SUCCESS, null);
        }
        return new Fallible<BackupStageOutcome>(BackupStageOutcome.FAILURE, new StoreCopyFailedException("End state of catchup was not a successful end of stream"));
    }
}

