/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import org.neo4j.backup.impl.ConsistencyCheckFailedException;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

public interface ConsistencyCheck {
    public static final ConsistencyCheck NONE = new ConsistencyCheck(){

        @Override
        public String name() {
            return "none";
        }

        @Override
        public boolean runFull(DatabaseLayout databaseLayout, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags) {
            return true;
        }
    };
    public static final ConsistencyCheck FULL = new ConsistencyCheck(){

        @Override
        public String name() {
            return "full";
        }

        @Override
        public boolean runFull(DatabaseLayout databaseLayout, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, ConsistencyFlags consistencyFlags) throws ConsistencyCheckFailedException {
            try {
                return new ConsistencyCheckService().runFullConsistencyCheck(databaseLayout, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, consistencyFlags).isSuccessful();
            }
            catch (ConsistencyCheckIncompleteException e) {
                throw new ConsistencyCheckFailedException(e);
            }
        }
    };

    public String name();

    public boolean runFull(DatabaseLayout var1, Config var2, ProgressMonitorFactory var3, LogProvider var4, FileSystemAbstraction var5, PageCache var6, boolean var7, ConsistencyFlags var8) throws ConsistencyCheckFailedException;

    public String toString();

    public static ConsistencyCheck fromString(String name) {
        for (ConsistencyCheck consistencyCheck : new ConsistencyCheck[]{NONE, FULL}) {
            if (!consistencyCheck.name().equalsIgnoreCase(name)) continue;
            return consistencyCheck;
        }
        throw new IllegalArgumentException("Unknown consistency check name: " + name + ". Supported values: NONE, FULL");
    }
}

