/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.OnlineBackupCommandSection;
import org.neo4j.backup.impl.BackupModule;
import org.neo4j.backup.impl.BackupStrategyCoordinatorFactory;
import org.neo4j.backup.impl.BackupSupportingClassesFactory;
import org.neo4j.backup.impl.BackupSupportingClassesFactoryProvider;
import org.neo4j.backup.impl.OnlineBackupCommand;
import org.neo4j.backup.impl.OnlineBackupContextFactory;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;

public class OnlineBackupCommandProvider
extends AdminCommand.Provider {
    public OnlineBackupCommandProvider() {
        super("backup", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return OnlineBackupContextFactory.arguments();
    }

    @Nonnull
    public String description() {
        return String.format("Perform an online backup from a running Neo4j enterprise server. Neo4j's backup service must have been configured on the server beforehand.%n%nAll consistency checks except 'cc-graph' can be quite expensive so it may be useful to turn them off for very large databases. Increasing the heap size can also be a good idea. See 'neo4j-admin help' for details.%n%nFor more information see: https://neo4j.com/docs/operations-manual/current/backup/", new Object[0]);
    }

    @Nonnull
    public String summary() {
        return "Perform an online backup from a running Neo4j enterprise server.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return OnlineBackupCommandSection.instance();
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        boolean debug = System.getenv().get("NEO4J_DEBUG") != null;
        FormattedLogProvider logProvider = FormattedLogProvider.withDefaultLogLevel((Level)(debug ? Level.DEBUG : Level.NONE)).toOutputStream((OutputStream)outsideWorld.outStream());
        Monitors monitors = new Monitors();
        OnlineBackupContextFactory contextBuilder = new OnlineBackupContextFactory(configDir);
        BackupModule backupModule = new BackupModule(outsideWorld, (LogProvider)logProvider, monitors);
        BackupSupportingClassesFactoryProvider classesFactoryProvider = BackupSupportingClassesFactoryProvider.getProvidersByPriority().findFirst().orElseThrow(OnlineBackupCommandProvider.noProviderException());
        BackupSupportingClassesFactory supportingClassesFactory = classesFactoryProvider.getFactory(backupModule);
        BackupStrategyCoordinatorFactory coordinatorFactory = new BackupStrategyCoordinatorFactory(backupModule);
        return new OnlineBackupCommand(outsideWorld, contextBuilder, supportingClassesFactory, coordinatorFactory);
    }

    private static Supplier<IllegalStateException> noProviderException() {
        return () -> new IllegalStateException("Unable to find a suitable backup supporting classes provider in the classpath");
    }
}

