/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.util.function.Supplier;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.storageengine.api.StoreId;

class StoreCopyResponsePacker
extends ResponsePacker {
    private final long mandatoryStartTransactionId;
    private final LogFileInformation logFileInformation;
    private final TransactionIdStore transactionIdStore;
    private final StoreCopyServer.Monitor monitor;

    StoreCopyResponsePacker(LogicalTransactionStore transactionStore, TransactionIdStore transactionIdStore, LogFileInformation logFileInformation, Supplier<StoreId> storeId, long mandatoryStartTransactionId, StoreCopyServer.Monitor monitor) {
        super(transactionStore, transactionIdStore, storeId);
        this.transactionIdStore = transactionIdStore;
        this.mandatoryStartTransactionId = mandatoryStartTransactionId;
        this.logFileInformation = logFileInformation;
        this.monitor = monitor;
    }

    public <T> Response<T> packTransactionStreamResponse(RequestContext context, T response) {
        String packerIdentifier = Thread.currentThread().getName();
        long toStartFrom = this.mandatoryStartTransactionId;
        long toEndAt = this.transactionIdStore.getLastCommittedTransactionId();
        TransactionStream transactions = visitor -> {
            if (toStartFrom > 1L && toStartFrom <= toEndAt) {
                this.monitor.startStreamingTransactions(toStartFrom, packerIdentifier);
                this.extractTransactions(toStartFrom, (Visitor<CommittedTransactionRepresentation, Exception>)this.filterVisitor(visitor, toEndAt));
                this.monitor.finishStreamingTransactions(toEndAt, packerIdentifier);
            }
        };
        return new TransactionStreamResponse(response, (StoreId)this.storeId.get(), transactions, ResourceReleaser.NO_OP);
    }

    protected void extractTransactions(long startingAtTransactionId, Visitor<CommittedTransactionRepresentation, Exception> accumulator) throws Exception {
        block5: {
            try {
                startingAtTransactionId = Math.min(this.mandatoryStartTransactionId, startingAtTransactionId);
                super.extractTransactions(startingAtTransactionId, accumulator);
            }
            catch (NoSuchTransactionException e) {
                if (startingAtTransactionId >= this.mandatoryStartTransactionId) break block5;
                long oldestExistingTransactionId = this.logFileInformation.getFirstExistingEntryId();
                if (oldestExistingTransactionId == -1L) {
                    if (this.mandatoryStartTransactionId >= this.transactionIdStore.getLastCommittedTransactionId()) {
                        return;
                    }
                    throw e;
                }
                if (oldestExistingTransactionId <= this.mandatoryStartTransactionId) {
                    super.extractTransactions(oldestExistingTransactionId, accumulator);
                }
                throw e;
            }
        }
    }
}

