/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.EnterpriseGraphDatabase;
import org.neo4j.kernel.impl.factory.Edition;

public class EnterpriseGraphDatabaseFactory
extends GraphDatabaseFactory {
    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Config config) {
                File absoluteStoreDir = storeDir.getAbsoluteFile();
                File databasesRoot = absoluteStoreDir.getParentFile();
                config.augment(GraphDatabaseSettings.ephemeral, "false");
                config.augment(GraphDatabaseSettings.active_database, absoluteStoreDir.getName());
                config.augment(GraphDatabaseSettings.databases_root_path, databasesRoot.getAbsolutePath());
                return new EnterpriseGraphDatabase(databasesRoot, config, state.databaseDependencies());
            }
        };
    }

    public String getEdition() {
        return Edition.enterprise.toString();
    }
}

