/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.api.security;

import java.util.Collections;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;

public class EnterpriseSecurityContext
extends SecurityContext {
    private final Set<String> roles;
    private final boolean isAdmin;
    public static final EnterpriseSecurityContext AUTH_DISABLED = EnterpriseSecurityContext.authDisabled((AccessMode)AccessMode.Static.FULL);

    public EnterpriseSecurityContext(AuthSubject subject, AccessMode mode, Set<String> roles, boolean isAdmin) {
        super(subject, mode);
        this.roles = roles;
        this.isAdmin = isAdmin;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public EnterpriseSecurityContext authorize(ToIntFunction<String> propertyIdLookup, String dbName) {
        return this;
    }

    public EnterpriseSecurityContext withMode(AccessMode mode) {
        return new EnterpriseSecurityContext(this.subject, mode, this.roles, this.isAdmin);
    }

    public Set<String> roles() {
        return this.roles;
    }

    private static EnterpriseSecurityContext authDisabled(AccessMode mode) {
        return new EnterpriseSecurityContext(AuthSubject.AUTH_DISABLED, mode, Collections.emptySet(), true){

            @Override
            public EnterpriseSecurityContext withMode(AccessMode mode) {
                return EnterpriseSecurityContext.authDisabled(mode);
            }

            public String description() {
                return "AUTH_DISABLED with " + this.mode().name();
            }

            public String toString() {
                return this.defaultString("enterprise-auth-disabled");
            }
        };
    }
}

