/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.util.stream.Stream;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class EnterpriseBuiltInProcedures {
    @Context
    public KernelTransaction tx;
    @Context
    public DependencyResolver resolver;

    @Description(value="Create a node key constraint with index backed by specified index provider (for example: CALL db.createNodeKey(\":Person(name)\", \"lucene+native-2.0\")) - YIELD index, providerName, status")
    @Procedure(name="db.createNodeKey", mode=Mode.SCHEMA)
    public Stream<BuiltInProcedures.SchemaIndexInfo> createNodeKey(@Name(value="index") String index, @Name(value="providerName") String providerName) throws ProcedureException {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            Stream stream = indexProcedures.createNodeKey(index, providerName);
            return stream;
        }
    }

    private IndexProcedures indexProcedures() {
        return new IndexProcedures(this.tx, (IndexingService)this.resolver.resolveDependency(IndexingService.class));
    }
}

