/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.net.SocketAddress;
import java.time.ZoneId;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.enterprise.builtinprocs.ProceduresTimeFormatHelper;

public class ListConnectionResult {
    public final String connectionId;
    public final String connectTime;
    public final String connector;
    public final String username;
    public final String userAgent;
    public final String serverAddress;
    public final String clientAddress;

    ListConnectionResult(TrackedNetworkConnection connection, ZoneId timeZone) {
        this.connectionId = connection.id();
        this.connectTime = ProceduresTimeFormatHelper.formatTime(connection.connectTime(), timeZone);
        this.connector = connection.connector();
        this.username = connection.username();
        this.userAgent = connection.userAgent();
        this.serverAddress = org.neo4j.helpers.SocketAddress.format((SocketAddress)connection.serverAddress());
        this.clientAddress = org.neo4j.helpers.SocketAddress.format((SocketAddress)connection.clientAddress());
    }
}

