/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceException;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.PropertyExistenceEnforcer;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class EnterpriseConstraintSemantics
extends StandardConstraintSemantics {
    public EnterpriseConstraintSemantics() {
        super("enterpriseConstraints", 2);
    }

    protected ConstraintDescriptor readNonStandardConstraint(ConstraintRule rule, String errorMessage) {
        if (!rule.getConstraintDescriptor().enforcesPropertyExistence()) {
            throw new IllegalStateException("Unsupported constraint type: " + rule);
        }
        return rule.getConstraintDescriptor();
    }

    public ConstraintRule createNodeKeyConstraintRule(long ruleId, NodeKeyConstraintDescriptor descriptor, long indexId) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)descriptor, (long)indexId);
    }

    public ConstraintRule createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)descriptor);
    }

    public void validateNodePropertyExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        while (allNodes.next()) {
            allNodes.node(nodeCursor);
            while (nodeCursor.next()) {
                for (int propertyKey : descriptor.getPropertyIds()) {
                    nodeCursor.properties(propertyCursor);
                    if (this.hasProperty(propertyCursor, propertyKey)) continue;
                    throw this.createConstraintFailure((ConstraintValidationException)new NodePropertyExistenceException(descriptor, ConstraintValidationException.Phase.VERIFICATION, nodeCursor.nodeReference()));
                }
            }
        }
    }

    public void validateNodeKeyConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        this.validateNodePropertyExistenceConstraint(allNodes, nodeCursor, propertyCursor, descriptor);
    }

    private boolean hasProperty(PropertyCursor propertyCursor, int property) {
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != property) continue;
            return true;
        }
        return false;
    }

    public void validateRelationshipPropertyExistenceConstraint(RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        while (relationshipCursor.next()) {
            relationshipCursor.properties(propertyCursor);
            for (int propertyKey : descriptor.getPropertyIds()) {
                if (relationshipCursor.type() != descriptor.getRelTypeId() || this.hasProperty(propertyCursor, propertyKey)) continue;
                throw this.createConstraintFailure((ConstraintValidationException)new RelationshipPropertyExistenceException(descriptor, ConstraintValidationException.Phase.VERIFICATION, relationshipCursor.relationshipReference()));
            }
        }
    }

    private CreateConstraintFailureException createConstraintFailure(ConstraintValidationException it) {
        return new CreateConstraintFailureException(it.constraint(), (Throwable)it);
    }

    public TxStateVisitor decorateTxStateVisitor(StorageReader storageReader, Read read, CursorFactory cursorFactory, ReadableTransactionState txState, TxStateVisitor visitor) {
        if (!txState.hasDataChanges()) {
            return visitor;
        }
        return PropertyExistenceEnforcer.getOrCreatePropertyExistenceEnforcerFrom(storageReader).decorate(visitor, read, cursorFactory);
    }
}

