/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.graphdb.factory.module.id.IdContextFactoryBuilder;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.provider.EnterpriseNoAuthSecurityProvider;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInProcedures;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.net.DefaultNetworkConnectionTracker;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class EnterpriseEditionModule
extends CommunityEditionModule {
    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
        procedures.registerProcedure(EnterpriseBuiltInProcedures.class, true);
    }

    public EnterpriseEditionModule(PlatformModule platformModule) {
        super(platformModule);
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
    }

    protected IdContextFactory createIdContextFactory(PlatformModule platformModule, FileSystemAbstraction fileSystem) {
        return IdContextFactoryBuilder.of((IdTypeConfigurationProvider)new EnterpriseIdTypeConfigurationProvider(platformModule.config), (JobScheduler)platformModule.jobScheduler).withFileSystem(fileSystem).build();
    }

    protected Predicate<String> fileWatcherFileNameFilter() {
        return EnterpriseEditionModule.enterpriseNonClusterFileWatcherFileNameFilter();
    }

    static Predicate<String> enterpriseNonClusterFileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db"), filename -> filename.endsWith(".cacheprof")});
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new EnterpriseConstraintSemantics();
    }

    protected NetworkConnectionTracker createConnectionTracker() {
        return new DefaultNetworkConnectionTracker();
    }

    protected StatementLocksFactory createStatementLocksFactory(Locks locks, Config config, LogService logService) {
        return new StatementLocksFactorySelector(locks, config, logService).select();
    }

    public void createSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.createEnterpriseSecurityModule((AbstractEditionModule)this, platformModule, procedures);
    }

    public static void createEnterpriseSecurityModule(AbstractEditionModule editionModule, PlatformModule platformModule, Procedures procedures) {
        EnterpriseNoAuthSecurityProvider securityProvider;
        if (((Boolean)platformModule.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            SecurityModule securityModule = EnterpriseEditionModule.setupSecurityModule((PlatformModule)platformModule, (AbstractEditionModule)editionModule, (Log)platformModule.logging.getUserLog(EnterpriseEditionModule.class), (Procedures)procedures, (String)((String)platformModule.config.get(EnterpriseEditionSettings.security_module)));
            platformModule.life.add((Lifecycle)securityModule);
            securityProvider = securityModule;
        } else {
            EnterpriseNoAuthSecurityProvider provider = EnterpriseNoAuthSecurityProvider.INSTANCE;
            platformModule.life.add((Lifecycle)provider);
            securityProvider = provider;
        }
        editionModule.setSecurityProvider((SecurityProvider)securityProvider);
    }
}

