/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceException;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class PropertyExistenceEnforcer {
    private final List<LabelSchemaDescriptor> nodeConstraints;
    private final List<RelationTypeSchemaDescriptor> relationshipConstraints;
    private final MutableLongObjectMap<int[]> mandatoryNodePropertiesByLabel = new LongObjectHashMap();
    private final MutableLongObjectMap<int[]> mandatoryRelationshipPropertiesByType = new LongObjectHashMap();
    private static final PropertyExistenceEnforcer NO_CONSTRAINTS = new PropertyExistenceEnforcer(Collections.emptyList(), Collections.emptyList()){

        @Override
        TxStateVisitor decorate(TxStateVisitor visitor, Read read, CursorFactory cursorFactory) {
            return visitor;
        }
    };
    private static final Function<StorageReader, PropertyExistenceEnforcer> FACTORY = storageReader -> {
        final ArrayList<LabelSchemaDescriptor> nodes = new ArrayList<LabelSchemaDescriptor>();
        final ArrayList<RelationTypeSchemaDescriptor> relationships = new ArrayList<RelationTypeSchemaDescriptor>();
        Iterator constraints = storageReader.constraintsGetAll();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.next();
            if (!constraint.enforcesPropertyExistence()) continue;
            constraint.schema().processWith(new SchemaProcessor(){

                public void processSpecific(LabelSchemaDescriptor schema) {
                    nodes.add(schema);
                }

                public void processSpecific(RelationTypeSchemaDescriptor schema) {
                    relationships.add(schema);
                }

                public void processSpecific(SchemaDescriptor schema) {
                    throw new UnsupportedOperationException("General SchemaDescriptor cannot support constraints");
                }
            });
        }
        if (nodes.isEmpty() && relationships.isEmpty()) {
            return NO_CONSTRAINTS;
        }
        return new PropertyExistenceEnforcer(nodes, relationships);
    };

    static PropertyExistenceEnforcer getOrCreatePropertyExistenceEnforcerFrom(StorageReader storageReader) {
        return (PropertyExistenceEnforcer)storageReader.getOrCreateSchemaDependantState(PropertyExistenceEnforcer.class, FACTORY);
    }

    private PropertyExistenceEnforcer(List<LabelSchemaDescriptor> nodes, List<RelationTypeSchemaDescriptor> rels) {
        this.nodeConstraints = nodes;
        this.relationshipConstraints = rels;
        for (LabelSchemaDescriptor labelSchemaDescriptor : nodes) {
            PropertyExistenceEnforcer.update(this.mandatoryNodePropertiesByLabel, labelSchemaDescriptor.getLabelId(), PropertyExistenceEnforcer.copyAndSortPropertyIds(labelSchemaDescriptor.getPropertyIds()));
        }
        for (RelationTypeSchemaDescriptor relationTypeSchemaDescriptor : rels) {
            PropertyExistenceEnforcer.update(this.mandatoryRelationshipPropertiesByType, relationTypeSchemaDescriptor.getRelTypeId(), PropertyExistenceEnforcer.copyAndSortPropertyIds(relationTypeSchemaDescriptor.getPropertyIds()));
        }
    }

    private static void update(MutableLongObjectMap<int[]> map, int key, int[] sortedValues) {
        int[] current = (int[])map.get((long)key);
        if (current != null) {
            sortedValues = PrimitiveArrays.union((int[])current, (int[])sortedValues);
        }
        map.put((long)key, (Object)sortedValues);
    }

    private static int[] copyAndSortPropertyIds(int[] propertyIds) {
        int[] values = new int[propertyIds.length];
        System.arraycopy(propertyIds, 0, values, 0, propertyIds.length);
        Arrays.sort(values);
        return values;
    }

    TxStateVisitor decorate(TxStateVisitor visitor, Read read, CursorFactory cursorFactory) {
        return new Decorator(visitor, read, cursorFactory);
    }

    private void validateNodeProperties(long id, LabelSet labelIds, IntSet propertyKeyIds) throws NodePropertyExistenceException {
        int numberOfLabels = labelIds.numberOfLabels();
        if (numberOfLabels > this.mandatoryNodePropertiesByLabel.size()) {
            MutableLongIterator labels = this.mandatoryNodePropertiesByLabel.keySet().longIterator();
            while (labels.hasNext()) {
                long label = labels.next();
                if (!labelIds.contains(Math.toIntExact(label))) continue;
                this.validateNodeProperties(id, label, (int[])this.mandatoryNodePropertiesByLabel.get(label), propertyKeyIds);
            }
        } else {
            for (int i = 0; i < numberOfLabels; ++i) {
                long label = labelIds.label(i);
                int[] keys = (int[])this.mandatoryNodePropertiesByLabel.get(label);
                if (keys == null) continue;
                this.validateNodeProperties(id, label, keys, propertyKeyIds);
            }
        }
    }

    private void validateNodeProperties(long id, long label, int[] requiredKeys, IntSet propertyKeyIds) throws NodePropertyExistenceException {
        for (int key : requiredKeys) {
            if (propertyKeyIds.contains(key)) continue;
            this.failNode(id, label, key);
        }
    }

    private void failNode(long id, long label, int propertyKey) throws NodePropertyExistenceException {
        for (LabelSchemaDescriptor constraint : this.nodeConstraints) {
            if ((long)constraint.getLabelId() != label || !this.contains(constraint.getPropertyIds(), propertyKey)) continue;
            throw new NodePropertyExistenceException(constraint, ConstraintValidationException.Phase.VALIDATION, id);
        }
        throw new IllegalStateException(String.format("Node constraint for label=%d, propertyKey=%d should exist.", label, propertyKey));
    }

    private void failRelationship(long id, int relationshipType, int propertyKey) throws RelationshipPropertyExistenceException {
        for (RelationTypeSchemaDescriptor constraint : this.relationshipConstraints) {
            if (constraint.getRelTypeId() != relationshipType || !this.contains(constraint.getPropertyIds(), propertyKey)) continue;
            throw new RelationshipPropertyExistenceException(constraint, ConstraintValidationException.Phase.VALIDATION, id);
        }
        throw new IllegalStateException(String.format("Relationship constraint for relationshipType=%d, propertyKey=%d should exist.", relationshipType, propertyKey));
    }

    private boolean contains(int[] list, int value) {
        for (int x : list) {
            if (value != x) continue;
            return true;
        }
        return false;
    }

    private class Decorator
    extends TxStateVisitor.Delegator {
        private final MutableIntSet propertyKeyIds;
        private final Read read;
        private final CursorFactory cursorFactory;
        private final NodeCursor nodeCursor;
        private final PropertyCursor propertyCursor;
        private final RelationshipScanCursor relationshipCursor;

        Decorator(TxStateVisitor next, Read read, CursorFactory cursorFactory) {
            super(next);
            this.propertyKeyIds = new IntHashSet();
            this.read = read;
            this.cursorFactory = cursorFactory;
            this.nodeCursor = cursorFactory.allocateNodeCursor();
            this.propertyCursor = cursorFactory.allocatePropertyCursor();
            this.relationshipCursor = cursorFactory.allocateRelationshipScanCursor();
        }

        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.validateNode(id);
            super.visitNodePropertyChanges(id, added, changed, removed);
        }

        public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
            this.validateNode(id);
            super.visitNodeLabelChanges(id, added, removed);
        }

        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
            this.validateRelationship(id);
            super.visitCreatedRelationship(id, type, startNode, endNode);
        }

        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.validateRelationship(id);
            super.visitRelPropertyChanges(id, added, changed, removed);
        }

        private void validateNode(long nodeId) throws NodePropertyExistenceException {
            LabelSet labelIds;
            if (PropertyExistenceEnforcer.this.mandatoryNodePropertiesByLabel.isEmpty()) {
                return;
            }
            this.read.singleNode(nodeId, this.nodeCursor);
            if (this.nodeCursor.next()) {
                labelIds = this.nodeCursor.labels();
                if (labelIds.numberOfLabels() == 0) {
                    return;
                }
                this.propertyKeyIds.clear();
                this.nodeCursor.properties(this.propertyCursor);
                while (this.propertyCursor.next()) {
                    this.propertyKeyIds.add(this.propertyCursor.propertyKey());
                }
            } else {
                throw new IllegalStateException(String.format("Node %d with changes should exist.", nodeId));
            }
            PropertyExistenceEnforcer.this.validateNodeProperties(nodeId, labelIds, (IntSet)this.propertyKeyIds);
        }

        private void validateRelationship(long id) throws RelationshipPropertyExistenceException {
            int[] required;
            int relationshipType;
            if (PropertyExistenceEnforcer.this.mandatoryRelationshipPropertiesByType.isEmpty()) {
                return;
            }
            this.read.singleRelationship(id, this.relationshipCursor);
            if (this.relationshipCursor.next()) {
                relationshipType = this.relationshipCursor.type();
                required = (int[])PropertyExistenceEnforcer.this.mandatoryRelationshipPropertiesByType.get((long)relationshipType);
                if (required == null) {
                    return;
                }
                this.propertyKeyIds.clear();
                this.relationshipCursor.properties(this.propertyCursor);
                while (this.propertyCursor.next()) {
                    this.propertyKeyIds.add(this.propertyCursor.propertyKey());
                }
            } else {
                throw new IllegalStateException(String.format("Relationship %d with changes should exist.", id));
            }
            for (int mandatory : required) {
                if (this.propertyKeyIds.contains(mandatory)) continue;
                PropertyExistenceEnforcer.this.failRelationship(id, relationshipType, mandatory);
            }
        }
    }
}

