/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.configuration;

import java.util.List;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.store.id.IdType;

public class EnterpriseEditionSettings
implements LoadableConfig {
    public static final String ENTERPRISE_SECURITY_MODULE_ID = "enterprise-security-module";
    @Description(value="Specified names of id types (comma separated) that should be reused. Currently only 'node' and 'relationship' types are supported. ")
    public static final Setting<List<IdType>> idTypesToReuse = Settings.setting((String)"dbms.ids.reuse.types.override", (Function)Settings.list((String)",", (Function)Settings.optionsIgnoreCase((Object[])new IdType[]{IdType.NODE, IdType.RELATIONSHIP})), (String)String.join((CharSequence)",", IdType.RELATIONSHIP.name(), IdType.NODE.name()));
    @Internal
    public static final Setting<String> security_module = Settings.setting((String)"unsupported.dbms.security.module", (Function)Settings.STRING, (String)"enterprise-security-module");
    @Description(value="Configure the operating mode of the database -- 'SINGLE' for stand-alone operation, 'HA' for operating as a member in an HA cluster, 'ARBITER' for a cluster member with no database in an HA cluster, 'CORE' for operating as a core member of a Causal Cluster, or 'READ_REPLICA' for operating as a read replica member of a Causal Cluster.")
    public static final Setting<Mode> mode = Settings.setting((String)"dbms.mode", (Function)Settings.optionsObeyCase(Mode.class), (String)Mode.SINGLE.name());

    public static enum Mode {
        SINGLE,
        HA,
        ARBITER,
        CORE,
        READ_REPLICA;

    }
}

