/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.lock.forseti;

import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.map.primitive.LongIntMap;
import org.eclipse.collections.api.map.primitive.MutableLongIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ExclusiveLock;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.enterprise.lock.forseti.SharedLock;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.LockWaitEvent;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class ForsetiClient
implements Locks.Client {
    private final int clientId;
    private final ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps;
    private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;
    private final ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy;
    private final Pool<ForsetiClient> clientPool;
    private final IntFunction<ForsetiClient> clientById;
    private final MutableLongIntMap[] sharedLockCounts;
    private final MutableLongIntMap[] exclusiveLockCounts;
    private final long lockAcquisitionTimeoutMillis;
    private final Clock clock;
    private final SimpleBitSet waitList = new SimpleBitSet(64);
    private long waitListCheckPoint;
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();
    private final ExclusiveLock myExclusiveLock = new ExclusiveLock(this);
    private volatile boolean hasLocks;
    private final ReleaseExclusiveLocksAndClearSharedVisitor releaseExclusiveAndClearSharedVisitor = new ReleaseExclusiveLocksAndClearSharedVisitor();
    private final ReleaseSharedDontCheckExclusiveVisitor releaseSharedDontCheckExclusiveVisitor = new ReleaseSharedDontCheckExclusiveVisitor();
    private volatile ForsetiLockManager.Lock waitingForLock;

    public ForsetiClient(int id, ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps, WaitStrategy<AcquireLockTimeoutException>[] waitStrategies, Pool<ForsetiClient> clientPool, ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy, IntFunction<ForsetiClient> clientById, long lockAcquisitionTimeoutMillis, Clock clock) {
        this.clientId = id;
        this.lockMaps = lockMaps;
        this.waitStrategies = waitStrategies;
        this.deadlockResolutionStrategy = deadlockResolutionStrategy;
        this.clientPool = clientPool;
        this.clientById = clientById;
        this.sharedLockCounts = new MutableLongIntMap[lockMaps.length];
        this.exclusiveLockCounts = new MutableLongIntMap[lockMaps.length];
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
        this.clock = clock;
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            this.sharedLockCounts[i] = new CountableLongIntHashMap();
            this.exclusiveLockCounts[i] = new CountableLongIntHashMap();
        }
    }

    public void reset() {
        this.stateHolder.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            MutableLongIntMap heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
            MutableLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                int tries = 0;
                SharedLock mySharedLock = null;
                long waitStartMillis = this.clock.millis();
                while (true) {
                    this.assertValid(waitStartMillis, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (mySharedLock == null) {
                            mySharedLock = new SharedLock(this);
                        }
                        if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                        break;
                    }
                    if (existingLock instanceof SharedLock) {
                        if (((SharedLock)existingLock).acquire(this)) {
                            break;
                        }
                    } else if (!(existingLock instanceof ExclusiveLock)) {
                        throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                    }
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(false, resourceType, new long[]{resourceId});
                    }
                    this.waitFor(existingLock, resourceType, resourceId, false, tries++);
                }
                heldShareLocks.put(resourceId, 1);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.clearWaitList();
            this.waitingForLock = null;
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        LockWaitEvent waitEvent = null;
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            MutableLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                ForsetiLockManager.Lock existingLock;
                int heldCount = heldLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                int tries = 0;
                long waitStartMillis = this.clock.millis();
                while ((existingLock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) != null) {
                    SharedLock sharedLock;
                    this.assertValid(waitStartMillis, resourceType, resourceId);
                    if (tries > 50 && existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(tracer, waitEvent, resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock, waitStartMillis)) break;
                    if (waitEvent == null) {
                        waitEvent = tracer.waitForLock(true, resourceType, new long[]{resourceId});
                    }
                    this.waitFor(existingLock, resourceType, resourceId, true, tries++);
                }
                heldLocks.put(resourceId, 1);
            }
        }
        finally {
            if (waitEvent != null) {
                waitEvent.close();
            }
            this.clearWaitList();
            this.waitingForLock = null;
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            MutableLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
            int heldCount = heldLocks.getIfAbsent(resourceId, -1);
            if (heldCount != -1) {
                heldLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                SharedLock sharedLock;
                if (lock instanceof SharedLock && this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId) && (sharedLock = (SharedLock)lock).tryAcquireUpdateLock(this)) {
                    if (sharedLock.numberOfHolders() == 1) {
                        heldLocks.put(resourceId, 1);
                        boolean bl = true;
                        return bl;
                    }
                    sharedLock.releaseUpdateLock();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            heldLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            MutableLongIntMap heldShareLocks;
            block12: {
                ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
                heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
                MutableLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
                int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    boolean bl = true;
                    return bl;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    boolean bl = true;
                    return bl;
                }
                long waitStartMillis = this.clock.millis();
                while (true) {
                    this.assertValid(waitStartMillis, resourceType, resourceId);
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                        break block12;
                    }
                    if (!(existingLock instanceof SharedLock)) {
                        if (!(existingLock instanceof ExclusiveLock)) throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                        boolean bl = false;
                        return bl;
                    }
                    if (((SharedLock)existingLock).acquire(this)) break block12;
                    if (((SharedLock)existingLock).isUpdateLock()) break;
                }
                boolean bl = false;
                return bl;
            }
            heldShareLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reEnterShared(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            MutableLongIntMap heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
            MutableLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
            int heldCount = heldShareLocks.getIfAbsent(resourceId, -1);
            if (heldCount != -1) {
                heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            if (heldExclusiveLocks.containsKey(resourceId)) {
                heldShareLocks.put(resourceId, 1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            MutableLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
            int heldCount = heldLocks.getIfAbsent(resourceId, -1);
            if (heldCount != -1) {
                heldLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            MutableLongIntMap sharedLocks = this.sharedLockCounts[resourceType.typeId()];
            MutableLongIntMap exclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, sharedLocks) || exclusiveLocks.containsKey(resourceId)) continue;
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> resourceTypeLocks = this.lockMaps[resourceType.typeId()];
            MutableLongIntMap exclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
            MutableLongIntMap sharedLocks = this.sharedLockCounts[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                if (this.releaseLocalLock(resourceType, resourceId, exclusiveLocks)) continue;
                if (sharedLocks.containsKey(resourceId)) {
                    SharedLock sharedLock;
                    ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)resourceTypeLocks.get(resourceId);
                    if (lock instanceof SharedLock) {
                        sharedLock = (SharedLock)lock;
                        if (sharedLock.isUpdateLock()) {
                            sharedLock.releaseUpdateLock();
                            continue;
                        }
                        throw new IllegalStateException("Incorrect state of exclusive lock. Lock should be updated to exclusive before attempt to release it. Lock: " + this);
                    }
                    sharedLock = new SharedLock(this);
                    resourceTypeLocks.put(resourceId, sharedLock);
                    continue;
                }
                this.releaseGlobalLock(resourceTypeLocks, resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private void releaseAllClientLocks() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            int size;
            MutableLongIntMap exclusiveLocks = this.exclusiveLockCounts[i];
            MutableLongIntMap sharedLocks = this.sharedLockCounts[i];
            if (exclusiveLocks != null) {
                size = exclusiveLocks.size();
                exclusiveLocks.forEachKey(this.releaseExclusiveAndClearSharedVisitor.initialize(sharedLocks, this.lockMaps[i]));
                if (size <= 32) {
                    if (size > 0) {
                        exclusiveLocks.clear();
                    }
                } else {
                    this.exclusiveLockCounts[i] = new LongIntHashMap();
                }
            }
            if (sharedLocks == null) continue;
            size = sharedLocks.size();
            sharedLocks.forEachKey(this.releaseSharedDontCheckExclusiveVisitor.initialize(this.lockMaps[i]));
            if (size <= 32) {
                if (size <= 0) continue;
                sharedLocks.clear();
                continue;
            }
            this.sharedLockCounts[i] = new LongIntHashMap();
        }
    }

    public void prepare() {
        this.stateHolder.prepare((Locks.Client)this);
    }

    public void stop() {
        if (this.stateHolder.stopClient()) {
            this.waitForAllClientsToLeave();
            this.releaseAllLocks();
        }
    }

    private void waitForAllClientsToLeave() {
        while (this.stateHolder.hasActiveClients()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public void close() {
        this.stateHolder.closeClient();
        this.waitForAllClientsToLeave();
        this.releaseAllLocks();
        this.clientPool.release((Object)this);
    }

    private void releaseAllLocks() {
        if (this.hasLocks) {
            this.releaseAllClientLocks();
            this.clearWaitList();
            this.hasLocks = false;
        }
    }

    public int getLockSessionId() {
        return this.clientId;
    }

    public Stream<ActiveLock> activeLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        ForsetiClient.collectActiveLocks((LongIntMap[])this.exclusiveLockCounts, locks, ActiveLock.Factory.EXCLUSIVE_LOCK);
        ForsetiClient.collectActiveLocks((LongIntMap[])this.sharedLockCounts, locks, ActiveLock.Factory.SHARED_LOCK);
        return locks.stream();
    }

    public long activeLockCount() {
        return this.countLocks((LongIntMap[])this.exclusiveLockCounts) + this.countLocks((LongIntMap[])this.sharedLockCounts);
    }

    private static void collectActiveLocks(LongIntMap[] counts, List<ActiveLock> locks, ActiveLock.Factory activeLock) {
        for (int typeId = 0; typeId < counts.length; ++typeId) {
            LongIntMap lockCounts = counts[typeId];
            if (lockCounts == null) continue;
            ResourceType resourceType = ResourceTypes.fromId((int)typeId);
            lockCounts.forEachKeyValue((LongIntProcedure & Serializable)(resourceId, count) -> locks.add(activeLock.create(resourceType, resourceId)));
        }
    }

    private long countLocks(LongIntMap[] lockCounts) {
        long count = 0L;
        for (LongIntMap lockCount : lockCounts) {
            if (lockCount == null) continue;
            count += (long)lockCount.size();
        }
        return count;
    }

    int waitListSize() {
        return this.waitList.size();
    }

    void copyWaitListTo(SimpleBitSet other) {
        other.put(this.waitList);
    }

    boolean isWaitingFor(int clientId) {
        return clientId != this.clientId && this.waitList.contains(clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.clientId == that.clientId;
    }

    public int hashCode() {
        return this.clientId;
    }

    public String toString() {
        return String.format("ForsetiClient[%d]", this.clientId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
        } else if (lock instanceof SharedLock && ((SharedLock)lock).release(this)) {
            ((SharedLock)lock).cleanUpdateHolder();
            lockMap.remove(resourceId);
        }
    }

    private boolean releaseLocalLock(ResourceType type, long resourceId, MutableLongIntMap localLocks) {
        int lockCount = localLocks.removeKeyIfAbsent(resourceId, -1);
        if (lockCount == -1) {
            throw new IllegalStateException(this + " cannot release lock that it does not hold: " + type + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(LockTracer tracer, LockWaitEvent waitEvent, ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock, long waitStartMillis) throws AcquireLockTimeoutException {
        int tries = 0;
        boolean holdsSharedLock = this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId);
        if (!holdsSharedLock) {
            if (!sharedLock.acquire(this)) {
                return false;
            }
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartMillis)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(tracer, waitEvent, resourceType, resourceId, sharedLock, tries, waitStartMillis);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(LockTracer tracer, LockWaitEvent priorEvent, ResourceType resourceType, long resourceId, SharedLock sharedLock, int tries, long waitStartMillis) throws AcquireLockTimeoutException {
        if (sharedLock.tryAcquireUpdateLock(this)) {
            LockWaitEvent waitEvent = null;
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.assertValid(waitStartMillis, resourceType, resourceId);
                    if (waitEvent == null && priorEvent == null) {
                        waitEvent = tracer.waitForLock(true, resourceType, new long[]{resourceId});
                    }
                    this.waitFor(sharedLock, resourceType, resourceId, true, tries++);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                sharedLock.releaseUpdateLock();
                if (e instanceof DeadlockDetectedException || e instanceof LockClientStoppedException) {
                    throw (RuntimeException)e;
                }
                throw new TransactionFailureException("Failed to upgrade shared lock to exclusive: " + sharedLock, e);
            }
            finally {
                if (waitEvent != null) {
                    waitEvent.close();
                }
                this.clearWaitList();
                this.waitingForLock = null;
            }
        }
        return false;
    }

    private void clearWaitList() {
        this.waitListCheckPoint = this.waitList.checkPointAndPut(this.waitListCheckPoint, this.clientId);
    }

    private void waitFor(ForsetiLockManager.Lock lock, ResourceType type, long resourceId, boolean exclusive, int tries) {
        this.waitingForLock = lock;
        this.clearAndCopyWaitList(lock);
        this.waitStrategies[type.typeId()].apply((long)tries);
        int b = lock.detectDeadlock(this.id());
        if (b != -1 && this.deadlockResolutionStrategy.shouldAbort(this, this.clientById.apply(b))) {
            UnsafeUtil.loadFence();
            String message = this + " can't acquire " + lock + " on " + type + "(" + resourceId + "), because holders of that lock are waiting for " + this + ".\n Wait list:" + lock.describeWaitList();
            if (lock.detectDeadlock(this.id()) != -1 && this.isDeadlockReal(lock, tries)) {
                throw new DeadlockDetectedException(message);
            }
        }
    }

    private void clearAndCopyWaitList(ForsetiLockManager.Lock lock) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
    }

    private boolean isDeadlockReal(ForsetiLockManager.Lock lock, int tries) {
        HashSet<ForsetiLockManager.Lock> waitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> owners = new HashSet<ForsetiClient>();
        HashSet<ForsetiLockManager.Lock> nextWaitedUpon = new HashSet<ForsetiLockManager.Lock>();
        HashSet<ForsetiClient> nextOwners = new HashSet<ForsetiClient>();
        lock.collectOwners(owners);
        do {
            waitedUpon.addAll(nextWaitedUpon);
            this.collectNextOwners(waitedUpon, owners, nextWaitedUpon, nextOwners);
            if (nextOwners.contains(this) && tries > 20) {
                nextOwners.clear();
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                this.collectNextOwners(waitedUpon, owners, nextWaitedUpon, nextOwners);
                if (nextOwners.contains(this)) {
                    return true;
                }
            }
            owners.clear();
            HashSet<ForsetiClient> ownersTmp = owners;
            owners = nextOwners;
            nextOwners = ownersTmp;
        } while (!nextWaitedUpon.isEmpty());
        return false;
    }

    private void collectNextOwners(Set<ForsetiLockManager.Lock> waitedUpon, Set<ForsetiClient> owners, Set<ForsetiLockManager.Lock> nextWaitedUpon, Set<ForsetiClient> nextOwners) {
        nextWaitedUpon.clear();
        for (ForsetiClient owner : owners) {
            ForsetiLockManager.Lock waitingForLock = owner.waitingForLock;
            if (waitingForLock == null || waitedUpon.contains(waitingForLock)) continue;
            nextWaitedUpon.add(waitingForLock);
        }
        for (ForsetiLockManager.Lock lck : nextWaitedUpon) {
            lck.collectOwners(nextOwners);
        }
    }

    String describeWaitList() {
        StringBuilder sb = new StringBuilder(String.format("%nClient[%d] waits for [", this.id()));
        IntIterator iter = this.waitList.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            int next = iter.next();
            if (next == this.clientId) continue;
            sb.append(!first ? "," : "").append(next);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.clientId;
    }

    private void assertValid(long waitStartMillis, ResourceType resourceType, long resourceId) {
        this.assertNotStopped();
        this.assertNotExpired(waitStartMillis, resourceType, resourceId);
    }

    private void assertNotStopped() {
        if (this.stateHolder.isStopped()) {
            throw new LockClientStoppedException((Locks.Client)this);
        }
    }

    private void assertNotExpired(long waitStartMillis, ResourceType resourceType, long resourceId) {
        if (this.lockAcquisitionTimeoutMillis > 0L && this.lockAcquisitionTimeoutMillis + waitStartMillis < this.clock.millis()) {
            throw new LockAcquisitionTimeoutException(resourceType, resourceId, this.lockAcquisitionTimeoutMillis);
        }
    }

    private static class CountableLongIntHashMap
    extends LongIntHashMap {
        CountableLongIntHashMap() {
        }

        public int size() {
            AbstractMutableIntValuesMap.SentinelValues sentinelValues = this.getSentinelValues();
            return this.getOccupiedWithData() + (sentinelValues == null ? 0 : sentinelValues.size());
        }
    }

    private class ReleaseExclusiveLocksAndClearSharedVisitor
    implements LongProcedure {
        private MutableLongIntMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksAndClearSharedVisitor() {
        }

        private LongProcedure initialize(MutableLongIntMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            if (this.sharedLockCounts != null) {
                this.sharedLockCounts.remove(resourceId);
            }
        }
    }

    private class ReleaseSharedDontCheckExclusiveVisitor
    implements LongProcedure {
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedDontCheckExclusiveVisitor() {
        }

        private LongProcedure initialize(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.lockMap = lockMap;
            return this;
        }

        public void value(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
        }
    }
}

