/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.lock.forseti;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiClient;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;

class SharedLock
implements ForsetiLockManager.Lock {
    private static final int UPDATE_LOCK_FLAG = Integer.MIN_VALUE;
    private static final int MAX_HOLDERS = 4680;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicReferenceArray<ForsetiClient>[] clientsHoldingThisLock = new AtomicReferenceArray[4];
    private ForsetiClient updateHolder;

    SharedLock(ForsetiClient client) {
        this.addClientHoldingLock(client);
    }

    public boolean acquire(ForsetiClient client) {
        if (!this.acquireReference()) {
            return false;
        }
        if (!this.clientHoldsThisLock(client)) {
            return this.addClientHoldingLock(client);
        }
        this.releaseReference();
        return false;
    }

    public boolean release(ForsetiClient client) {
        this.removeClientHoldingLock(client);
        return this.releaseReference();
    }

    @Override
    public void copyHolderWaitListsInto(SimpleBitSet waitList) {
        for (AtomicReferenceArray<ForsetiClient> holders : this.clientsHoldingThisLock) {
            for (int j = 0; holders != null && j < holders.length(); ++j) {
                ForsetiClient client = holders.get(j);
                if (client == null) continue;
                client.copyWaitListTo(waitList);
            }
        }
    }

    @Override
    public int detectDeadlock(int clientId) {
        for (AtomicReferenceArray<ForsetiClient> holders : this.clientsHoldingThisLock) {
            for (int j = 0; holders != null && j < holders.length(); ++j) {
                ForsetiClient client = holders.get(j);
                if (client == null || !client.isWaitingFor(clientId)) continue;
                return client.id();
            }
        }
        return -1;
    }

    public boolean tryAcquireUpdateLock(ForsetiClient client) {
        int refs;
        while ((refs = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(refs, refs | Integer.MIN_VALUE)) continue;
            this.updateHolder = client;
            return true;
        }
        return false;
    }

    public void releaseUpdateLock() {
        int refs;
        do {
            refs = this.refCount.get();
            this.cleanUpdateHolder();
        } while (!this.refCount.compareAndSet(refs, refs & Integer.MAX_VALUE));
    }

    public void cleanUpdateHolder() {
        this.updateHolder = null;
    }

    public int numberOfHolders() {
        return this.refCount.get() & Integer.MAX_VALUE;
    }

    public boolean isUpdateLock() {
        return (this.refCount.get() & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @Override
    public String describeWaitList() {
        StringBuilder sb = new StringBuilder("SharedLock[");
        for (AtomicReferenceArray<ForsetiClient> holders : this.clientsHoldingThisLock) {
            boolean first = true;
            for (int j = 0; holders != null && j < holders.length(); ++j) {
                ForsetiClient current = holders.get(j);
                if (current == null) continue;
                sb.append(first ? "" : ", ").append(current.describeWaitList());
                first = false;
            }
        }
        return sb.append("]").toString();
    }

    @Override
    public void collectOwners(Set<ForsetiClient> owners) {
        for (AtomicReferenceArray<ForsetiClient> ownerArray : this.clientsHoldingThisLock) {
            if (ownerArray == null) continue;
            int len = ownerArray.length();
            for (int i = 0; i < len; ++i) {
                ForsetiClient owner = ownerArray.get(i);
                if (owner == null) continue;
                owners.add(owner);
            }
        }
    }

    public String toString() {
        if (this.isUpdateLock()) {
            return "UpdateLock{objectId=" + System.identityHashCode(this) + ", refCount=" + (this.refCount.get() & Integer.MAX_VALUE) + ", holder=" + this.updateHolder + '}';
        }
        return "SharedLock{objectId=" + System.identityHashCode(this) + ", refCount=" + this.refCount + '}';
    }

    private void removeClientHoldingLock(ForsetiClient client) {
        for (AtomicReferenceArray<ForsetiClient> holders : this.clientsHoldingThisLock) {
            if (holders == null) break;
            for (int j = 0; j < holders.length(); ++j) {
                ForsetiClient current = holders.get(j);
                if (current == null || !current.equals(client)) continue;
                holders.set(j, null);
                return;
            }
        }
        throw new IllegalStateException(client + " asked to be removed from holder list, but it does not hold " + this);
    }

    private boolean addClientHoldingLock(ForsetiClient client) {
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= this.clientsHoldingThisLock.length) continue block0;
                AtomicReferenceArray<ForsetiClient> holders = this.clientsHoldingThisLock[i];
                if (holders == null) {
                    holders = this.addHolderArray(i);
                }
                for (int j = 0; j < holders.length(); ++j) {
                    ForsetiClient c = holders.get(j);
                    if (c != null || !holders.compareAndSet(j, null, client)) continue;
                    return true;
                }
                ++i;
            }
            break;
        }
    }

    private boolean acquireReference() {
        int refs;
        while ((refs = this.refCount.get()) > 0 && refs < 4680) {
            if (!this.refCount.compareAndSet(refs, refs + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean releaseReference() {
        int newRefCount;
        int refAndUpdateFlag;
        while (!this.refCount.compareAndSet(refAndUpdateFlag = this.refCount.get(), (newRefCount = (refAndUpdateFlag & Integer.MAX_VALUE) - 1) | refAndUpdateFlag & Integer.MIN_VALUE)) {
        }
        return newRefCount == 0;
    }

    private synchronized AtomicReferenceArray<ForsetiClient> addHolderArray(int slot) {
        if (this.clientsHoldingThisLock[slot] == null) {
            this.clientsHoldingThisLock[slot] = new AtomicReferenceArray((int)(8.0 * Math.pow(8.0, slot)));
        }
        return this.clientsHoldingThisLock[slot];
    }

    private boolean clientHoldsThisLock(ForsetiClient client) {
        for (AtomicReferenceArray<ForsetiClient> holders : this.clientsHoldingThisLock) {
            for (int j = 0; holders != null && j < holders.length(); ++j) {
                ForsetiClient current = holders.get(j);
                if (current == null || !current.equals(client)) continue;
                return true;
            }
        }
        return false;
    }
}

